/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTFunction;

public class ASTMethod
extends ASTFunction
implements IASTMethod {
    private final List constructorChainElements;
    private final boolean isConst;
    private final boolean isDestructor;
    private final boolean isConstructor;
    private final boolean isExplicit;
    private final boolean isPureVirtual;
    private final boolean isVirtual;
    private final boolean isVolatile;
    private final ASTAccessVisibility visibility;
    private final IASTQualifiedNameElement qualifiedName;

    public ASTMethod(IASTScope scope, String name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isConstructor, boolean isDestructor, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChainElements, boolean hasFunctionTryBlock, boolean hasVarArgs) {
        super(scope, name, parameters, returnType, exception, isInline, isFriend, isStatic, startOffset, startLine, nameOffset, nameEndOffset, ownerTemplate, hasFunctionTryBlock, hasVarArgs, nameLine);
        this.isVirtual = isVirtual;
        this.isPureVirtual = isPureVirtual;
        this.isConstructor = isConstructor;
        this.isDestructor = isDestructor;
        this.isExplicit = isExplicit;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.visibility = visibility;
        this.constructorChainElements = constructorChainElements;
        this.qualifiedName = new ASTQualifiedNamedElement(scope, name);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isExplicit() {
        return this.isExplicit;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDestructor() {
        return this.isDestructor;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isPureVirtual() {
        return this.isPureVirtual;
    }

    public ASTAccessVisibility getVisiblity() {
        return this.visibility;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            if (this.isFriend()) {
                requestor.acceptFriendDeclaration(this);
            } else {
                requestor.acceptMethodDeclaration(this);
            }
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterMethodBody(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitMethodBody(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getConstructorChainInitializers() {
        if (this.constructorChainElements == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.constructorChainElements.iterator();
    }

    public IASTClassSpecifier getOwnerClassSpecifier() {
        return (IASTClassSpecifier)this.getOwnerScope();
    }
}

