/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.problem;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class Problem
implements IProblem {
    private final String arg;
    private final int id;
    private final int sourceStart;
    private final int sourceEnd;
    private final int lineNumber;
    private final boolean isError;
    private final boolean isWarning;
    private final char[] originatingFileName;
    private String message = null;
    protected static final Map errorMessages = new HashMap();
    protected static final String PROBLEM_PATTERN = "BaseProblemFactory.problemPattern";

    static {
        errorMessages.put(new Integer(0x8000001), ParserMessages.getString("ASTProblemFactory.error.semantic.uniqueNamePredefined"));
        errorMessages.put(new Integer(0x8000002), ParserMessages.getString("ASTProblemFactory.error.semantic.nameNotFound"));
        errorMessages.put(new Integer(0x8000003), ParserMessages.getString("ASTProblemFactory.error.semantic.nameNotProvided"));
        errorMessages.put(new Integer(0x800000F), ParserMessages.getString("ASTProblemFactory.error.semantic.invalidConversionType"));
        errorMessages.put(new Integer(0x8000006), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.ambiguousLookup"));
        errorMessages.put(new Integer(0x8000007), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidType"));
        errorMessages.put(new Integer(0x8000008), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.circularInheritance"));
        errorMessages.put(new Integer(0x8000004), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidOverload"));
        errorMessages.put(new Integer(0x8000009), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidTemplate"));
        errorMessages.put(new Integer(0x8000005), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidUsing"));
        errorMessages.put(new Integer(0x800000A), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.badVisibility"));
        errorMessages.put(new Integer(0x800000B), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.unableToResolveFunction"));
        errorMessages.put(new Integer(0x800000C), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidTemplateArgument"));
        errorMessages.put(new Integer(0x800000D), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidTemplateParameter"));
        errorMessages.put(new Integer(0x800000E), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.redeclaredTemplateParameter"));
        errorMessages.put(new Integer(134217746), ParserMessages.getString("ASTProblemFactory.error.semantic.pst.recursiveTemplateInstantiation"));
        errorMessages.put(new Integer(0x2000001), ParserMessages.getString("ScannerProblemFactory.error.preproc.error"));
        errorMessages.put(new Integer(0x2000002), ParserMessages.getString("ScannerProblemFactory.error.preproc.inclusionNotFound"));
        errorMessages.put(new Integer(0x2000003), ParserMessages.getString("ScannerProblemFactory.error.preproc.definitionNotFound"));
        errorMessages.put(new Integer(0x2000005), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroDefn"));
        errorMessages.put(new Integer(0x2000007), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroRedefn"));
        errorMessages.put(new Integer(0x2000004), ParserMessages.getString("ScannerProblemFactory.error.preproc.unbalancedConditional"));
        errorMessages.put(new Integer(0x2000008), ParserMessages.getString("ScannerProblemFactory.error.preproc.conditionalEval"));
        errorMessages.put(new Integer(0x2000009), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroUsage"));
        errorMessages.put(new Integer(0x200000B), ParserMessages.getString("ScannerProblemFactory.error.preproc.circularInclusion"));
        errorMessages.put(new Integer(0x2000006), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidDirective"));
        errorMessages.put(new Integer(0x200000A), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroPasting"));
        errorMessages.put(new Integer(0x1000003), ParserMessages.getString("ScannerProblemFactory.error.scanner.invalidEscapeChar"));
        errorMessages.put(new Integer(0x1000002), ParserMessages.getString("ScannerProblemFactory.error.scanner.unboundedString"));
        errorMessages.put(new Integer(0x1000004), ParserMessages.getString("ScannerProblemFactory.error.scanner.badFloatingPoint"));
        errorMessages.put(new Integer(0x1000005), ParserMessages.getString("ScannerProblemFactory.error.scanner.badHexFormat"));
        errorMessages.put(new Integer(0x1000006), ParserMessages.getString("ScannerProblemFactory.error.scanner.unexpectedEOF"));
        errorMessages.put(new Integer(0x1000001), ParserMessages.getString("ScannerProblemFactory.error.scanner.badCharacter"));
        errorMessages.put(new Integer(0x4000001), ParserMessages.getString("ParserProblemFactory.error.syntax.syntaxError"));
    }

    public Problem(int id, int start, int end, int line, char[] file, String arg, boolean warn, boolean error) {
        this.id = id;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.lineNumber = line;
        this.originatingFileName = file;
        this.arg = arg;
        this.isWarning = warn;
        this.isError = error;
    }

    public int getID() {
        return this.id;
    }

    public char[] getOriginatingFileName() {
        return this.originatingFileName;
    }

    public int getSourceEnd() {
        return this.sourceEnd;
    }

    public int getSourceLineNumber() {
        return this.lineNumber;
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String msg = (String)errorMessages.get(new Integer(this.id));
        if (msg == null) {
            msg = "";
        }
        if (this.arg != null) {
            msg = MessageFormat.format(msg, this.arg);
        }
        Object[] args = new Object[]{msg, new String(this.originatingFileName), new Integer(this.lineNumber)};
        this.message = ParserMessages.getFormattedString(PROBLEM_PATTERN, args);
        return this.message;
    }

    public boolean checkCategory(int bitmask) {
        return (this.id & bitmask) != 0;
    }

    public String getArguments() {
        return this.arg;
    }
}

