/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;

public class TypeInfo {
    public static final int isAuto = 1;
    public static final int isRegister = 2;
    public static final int isStatic = 4;
    public static final int isExtern = 8;
    public static final int isMutable = 16;
    public static final int isInline = 32;
    public static final int isVirtual = 64;
    public static final int isExplicit = 128;
    public static final int isTypedef = 256;
    public static final int isFriend = 512;
    public static final int isConst = 1024;
    public static final int isVolatile = 2048;
    public static final int isUnsigned = 4096;
    public static final int isShort = 8192;
    public static final int isLong = 16384;
    public static final int isForward = 32768;
    public static final int isComplex = 65536;
    public static final int isImaginary = 131072;
    public static final int isLongLong = 262144;
    public static final int isSigned = 524288;
    public static final eType t_any = new eType(-1);
    public static final eType t_undef = new eType(0);
    public static final eType t_type = new eType(1);
    public static final eType t_namespace = new eType(2);
    public static final eType t_class = new eType(3);
    public static final eType t_struct = new eType(4);
    public static final eType t_union = new eType(5);
    public static final eType t_enumeration = new eType(6);
    public static final eType t_constructor = new eType(7);
    public static final eType t_function = new eType(8);
    public static final eType t__Bool = new eType(9);
    public static final eType t_bool = new eType(10);
    public static final eType t_char = new eType(11);
    public static final eType t_wchar_t = new eType(12);
    public static final eType t_int = new eType(13);
    public static final eType t_float = new eType(14);
    public static final eType t_double = new eType(15);
    public static final eType t_void = new eType(16);
    public static final eType t_enumerator = new eType(17);
    public static final eType t_block = new eType(18);
    public static final eType t_template = new eType(19);
    public static final eType t_asm = new eType(20);
    public static final eType t_linkage = new eType(21);
    public static final eType t_templateParameter = new eType(22);
    public static final eType t_typeName = new eType(23);
    private static final String[] _image = new String[]{"", "", "namespace", "class", "struct", "union", "enum", "", "", "_Bool", "bool", "char", "wchar_t", "int", "float", "double", "void", "", "", "template", "", "", "", "typename"};
    private int _typeBits = 0;
    private eType _type = t_undef;
    private eType _templateParameterType = t_typeName;
    private ISymbol _typeDeclaration;
    private boolean _hasDefaultValue = false;
    private Object _defaultValue = null;
    private List _ptrOperators = Collections.EMPTY_LIST;
    private List _operatorExpressions = Collections.EMPTY_LIST;

    public TypeInfo() {
    }

    public TypeInfo(eType type, int bits, ISymbol symbol) {
        this._typeBits = bits;
        this._type = type;
        this._typeDeclaration = symbol;
    }

    public TypeInfo(eType type, int bits, ISymbol symbol, PtrOp op, boolean hasDefault) {
        this._typeBits = bits;
        this._type = type;
        this._typeDeclaration = symbol;
        if (op != null) {
            this._ptrOperators = new ArrayList(2);
            this._ptrOperators.add(op);
        } else {
            this._ptrOperators = Collections.EMPTY_LIST;
        }
        this._hasDefaultValue = hasDefault;
    }

    public TypeInfo(eType type, int bits, ISymbol symbol, PtrOp op, Object def) {
        this._typeBits = bits;
        this._type = type;
        this._typeDeclaration = symbol;
        if (op != null) {
            this._ptrOperators = new ArrayList(1);
            this._ptrOperators.add(op);
        } else {
            this._ptrOperators = Collections.EMPTY_LIST;
        }
        this._hasDefaultValue = true;
        this.setDefault(def);
    }

    public TypeInfo(TypeInfo info) {
        this._typeBits = info._typeBits;
        this._type = info._type;
        this._typeDeclaration = info._typeDeclaration;
        this._ptrOperators = info._ptrOperators == Collections.EMPTY_LIST ? info._ptrOperators : (ArrayList)((ArrayList)info._ptrOperators).clone();
        this._hasDefaultValue = info._hasDefaultValue;
        this._defaultValue = info._defaultValue;
    }

    public void setBit(boolean b, int mask) {
        this._typeBits = b ? (this._typeBits |= mask) : (this._typeBits &= ~mask);
    }

    public boolean checkBit(int mask) {
        return (this._typeBits & mask) != 0;
    }

    public void setType(eType t) {
        this._type = t;
    }

    public eType getType() {
        return this._type;
    }

    public boolean isType(eType type) {
        return this.isType(type, t_undef);
    }

    public int getTypeInfo() {
        return this._typeBits;
    }

    public void setTypeInfo(int typeInfo) {
        this._typeBits = typeInfo;
    }

    public eType getTemplateParameterType() {
        return this._templateParameterType;
    }

    public void setTemplateParameterType(eType type) {
        this._templateParameterType = type;
    }

    public TypeInfo getFinalType(ParserSymbolTable.TypeInfoProvider infoProvider) {
        return ParserSymbolTable.getFlatTypeInfo(this, infoProvider);
    }

    public boolean isType(eType type, eType upperType) {
        if (type == t_any) {
            return true;
        }
        if (upperType == t_undef) {
            return this.getType() == type;
        }
        return this.getType().compareTo(type) >= 0 && this.getType().compareTo(upperType) <= 0;
    }

    public ISymbol getTypeSymbol() {
        return this._typeDeclaration;
    }

    public void setTypeSymbol(ISymbol type) {
        this._typeDeclaration = type;
    }

    public boolean hasPtrOperators() {
        return this._ptrOperators.size() > 0;
    }

    public List getPtrOperators() {
        return this._ptrOperators;
    }

    public boolean hasSamePtrs(TypeInfo type) {
        int size = this.getPtrOperators().size();
        int size2 = type.getPtrOperators().size();
        PtrOp ptr1 = null;
        PtrOp ptr2 = null;
        if (size == size2) {
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    ptr1 = (PtrOp)this.getPtrOperators().get(i);
                    ptr2 = (PtrOp)type.getPtrOperators().get(i);
                    if (ptr1.getType() != ptr2.getType()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public List getOperatorExpressions() {
        return this._operatorExpressions;
    }

    public void applyOperatorExpressions(List ops) {
        if (ops == null || ops.isEmpty()) {
            return;
        }
        int size = ops.size();
        OperatorExpression op = null;
        int i = 0;
        while (i < size) {
            op = (OperatorExpression)ops.get(i);
            if (op == OperatorExpression.indirection || op == OperatorExpression.subscript) {
                ListIterator iterator;
                PtrOp last;
                if (this.hasPtrOperators() && ((last = (PtrOp)(iterator = this.getPtrOperators().listIterator(this.getPtrOperators().size())).previous()).getType() == PtrOp.t_pointer || last.getType() == PtrOp.t_array)) {
                    iterator.remove();
                }
            } else if (op == OperatorExpression.addressof) {
                PtrOp newOp = new PtrOp(PtrOp.t_pointer);
                this.addPtrOperator(newOp);
            }
            ++i;
        }
    }

    public void addPtrOperator(PtrOp ptr) {
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(4);
        }
        if (ptr != null) {
            this._ptrOperators.add(ptr);
        }
    }

    public void addPtrOperator(List ptrs) {
        if (ptrs == null || ptrs.size() == 0) {
            return;
        }
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(ptrs.size());
        }
        int size = ptrs.size();
        int i = 0;
        while (i < size) {
            this._ptrOperators.add(ptrs.get(i));
            ++i;
        }
    }

    public void preparePtrOperators(int numPtrOps) {
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(numPtrOps);
        } else {
            ((ArrayList)this._ptrOperators).ensureCapacity(numPtrOps);
        }
    }

    public void addOperatorExpression(OperatorExpression exp) {
        if (this._operatorExpressions == Collections.EMPTY_LIST) {
            this._operatorExpressions = new ArrayList(4);
        }
        this._operatorExpressions.add(exp);
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean def) {
        this._hasDefaultValue = def;
    }

    public void setDefault(Object t) {
        this._defaultValue = t;
    }

    public Object getDefault() {
        return this._defaultValue;
    }

    public boolean isForwardDeclaration() {
        return this.checkBit(32768);
    }

    public void setIsForwardDeclaration(boolean forward) {
        this.setBit(forward, 32768);
    }

    public boolean canHold(TypeInfo type) {
        if (this.getType().compareTo(type.getType()) > 0) {
            return true;
        }
        int mask = 286720;
        return (this.getTypeInfo() & mask) >= (type.getTypeInfo() & mask);
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof TypeInfo)) {
            return false;
        }
        TypeInfo type = (TypeInfo)t;
        boolean result = this._typeBits == type._typeBits;
        result &= this._type == type._type;
        if (this._typeDeclaration != null && type._typeDeclaration != null) {
            if (this._typeDeclaration.isType(t__Bool, t_void) && type._typeDeclaration.isType(t__Bool, t_void)) {
                result &= this._typeDeclaration.getType() == type._typeDeclaration.getType();
            } else if (this._typeDeclaration.isType(t_function) && type._typeDeclaration.isType(t_function)) {
                IParameterizedSymbol f1 = (IParameterizedSymbol)this._typeDeclaration;
                IParameterizedSymbol f2 = (IParameterizedSymbol)type._typeDeclaration;
                result &= f1.hasSameParameters(f2);
                result = f1.getReturnType() != null && f2.getReturnType() != null ? (result &= f1.getReturnType().getTypeInfo().equals(f2.getReturnType().getTypeInfo())) : (result &= f1.getReturnType() == f2.getReturnType());
            } else {
                result = this._typeDeclaration.isType(t_templateParameter) && type._typeDeclaration.isType(t_templateParameter) ? (result &= TemplateEngine.templateParametersAreEquivalent(this._typeDeclaration, type._typeDeclaration)) : (this._typeDeclaration instanceof IDeferredTemplateInstance && type._typeDeclaration instanceof IDeferredTemplateInstance ? (result &= TemplateEngine.deferedInstancesAreEquivalent((IDeferredTemplateInstance)this._typeDeclaration, (IDeferredTemplateInstance)type._typeDeclaration)) : (result &= this._typeDeclaration == type._typeDeclaration));
            }
        } else {
            result &= this._typeDeclaration == type._typeDeclaration;
        }
        int size1 = this._ptrOperators.size();
        int size2 = type._ptrOperators.size();
        if (size1 == size2) {
            if (size1 != 0) {
                PtrOp op1 = null;
                PtrOp op2 = null;
                int i = 0;
                while (i < size1) {
                    op1 = (PtrOp)this._ptrOperators.get(i);
                    if (!op1.equals(op2 = (PtrOp)type._ptrOperators.get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
        } else {
            return false;
        }
        return result;
    }

    public String toString() {
        if (this.isType(t_type)) {
            return this._typeDeclaration.getName();
        }
        return _image[this.getType().toInt()];
    }

    public void clear() {
        this._typeBits = 0;
        this._type = t_undef;
        this._templateParameterType = t_typeName;
        this._typeDeclaration = null;
        this._hasDefaultValue = false;
        this._defaultValue = null;
        this._ptrOperators = Collections.EMPTY_LIST;
        this._operatorExpressions = Collections.EMPTY_LIST;
    }

    public void copy(TypeInfo t) {
        this._typeBits = t._typeBits;
        this._type = t._type;
        this._templateParameterType = t._templateParameterType;
        this._typeDeclaration = t._typeDeclaration;
        this._hasDefaultValue = t._hasDefaultValue;
        this._defaultValue = t._defaultValue;
        this._ptrOperators = t._ptrOperators != Collections.EMPTY_LIST ? (ArrayList)((ArrayList)t._ptrOperators).clone() : Collections.EMPTY_LIST;
        this._operatorExpressions = t._operatorExpressions != Collections.EMPTY_LIST ? (ArrayList)((ArrayList)t._operatorExpressions).clone() : Collections.EMPTY_LIST;
    }

    public static class eType
    implements Comparable {
        private int _val;

        protected eType(int v) {
            this._val = v;
        }

        public int compareTo(Object o) {
            eType t = (eType)o;
            return this._val - t._val;
        }

        public int toInt() {
            return this._val;
        }
    }

    public static class OperatorExpression
    extends Enum {
        public static final OperatorExpression indirection = new OperatorExpression(1);
        public static final OperatorExpression addressof = new OperatorExpression(0);
        public static final OperatorExpression subscript = new OperatorExpression(2);

        protected OperatorExpression(int enumValue) {
            super(enumValue);
        }
    }

    public static class PtrOp {
        public static final eType t_undef_ptr = new eType(0);
        public static final eType t_pointer = new eType(1);
        public static final eType t_reference = new eType(2);
        public static final eType t_array = new eType(3);
        public static final eType t_memberPointer = new eType(4);
        private eType type = t_undef_ptr;
        private boolean isConstPtr = false;
        private boolean isVolatilePtr = false;
        private ISymbol memberOf = null;

        public PtrOp(eType type) {
            this.type = type;
        }

        public PtrOp(eType type, boolean isConst, boolean isVolatile) {
            this.type = type;
            this.isConstPtr = isConst;
            this.isVolatilePtr = isVolatile;
        }

        public PtrOp(ISymbol memberOf, boolean isConst, boolean isVolatile) {
            this.type = t_memberPointer;
            this.isConstPtr = isConst;
            this.isVolatilePtr = isVolatile;
            this.memberOf = memberOf;
        }

        public PtrOp() {
        }

        public eType getType() {
            return this.type;
        }

        public void setType(eType type) {
            this.type = type;
        }

        public boolean isConst() {
            return this.isConstPtr;
        }

        public boolean isVolatile() {
            return this.isVolatilePtr;
        }

        public void setConst(boolean isConst) {
            this.isConstPtr = isConst;
        }

        public void setVolatile(boolean isVolatile) {
            this.isVolatilePtr = isVolatile;
        }

        public ISymbol getMemberOf() {
            return this.memberOf;
        }

        public void setMemberOf(ISymbol member) {
            this.memberOf = member;
        }

        public int compareCVTo(PtrOp ptr) {
            int cv1 = (this.isConst() ? 1 : 0) + (this.isVolatile() ? 1 : 0);
            int cv2 = (ptr.isConst() ? 1 : 0) + (ptr.isVolatile() ? 1 : 0);
            return cv1 - cv2;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof PtrOp)) {
                return false;
            }
            PtrOp op = (PtrOp)o;
            return this.isConst() == op.isConst() && this.isVolatile() == op.isVolatile() && this.getType() == op.getType();
        }
    }
}

