/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CGlobalVariable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;

public class CDIDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        return new CLineBreakpoint(resource, attributes, register);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String sourceHandle, IResource resource, long address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(0));
        attributes.put("charEnd", new Integer(0));
        attributes.put("lineNumber", new Integer(-1));
        attributes.put("lineNumber", new Integer(-1));
        attributes.put("org.eclipse.cdt.debug.core.address", Long.toString(address));
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        return new CAddressBreakpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.expression", expression);
        attributes.put("org.eclipse.cdt.debug.core.read", new Boolean(readAccess));
        attributes.put("org.eclipse.cdt.debug.core.write", new Boolean(writeAccess));
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("org.eclipse.cdt.debug.core.function", function);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(ignoreCount));
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        return new CFunctionBreakpoint(resource, attributes, register);
    }

    public static ICLineBreakpoint lineBreakpointExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICLineBreakpoint && (breakpoint = (ICLineBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && sourceHandle != null && sourceHandle.equals(breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICAddressBreakpoint addressBreakpointExists(String sourceHandle, IResource resource, long address) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CAddressBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICAddressBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICAddressBreakpoint && (breakpoint = (ICAddressBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && sourceHandle != null && sourceHandle.equals(breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource)) {
                try {
                    if (Long.parseLong(breakpoint.getAddress()) == address) {
                        return breakpoint;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
        return null;
    }

    public static ICWatchpoint watchpointExists(String sourceHandle, IResource resource, String expression) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CWatchpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICWatchpoint breakpoint;
            if (breakpoints[i] instanceof ICWatchpoint && (breakpoint = (ICWatchpoint)breakpoints[i]).getMarker().getType().equals(markerType) && sourceHandle != null && sourceHandle.equals(breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getExpression().equals(expression)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICFunctionBreakpoint functionBreakpointExists(String sourceHandle, IResource resource, String function) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICFunctionBreakpoint && (breakpoint = (ICFunctionBreakpoint)breakpoints[i]).getMarker().getType().equals(markerType) && sourceHandle != null && sourceHandle.equals(breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(function)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static IExpression createExpression(IDebugTarget target, String text) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression cdiExpression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(text);
                return new CExpression((CDebugTarget)target, cdiExpression);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
            }
        }
        return null;
    }

    public static IExpression createExpressionForGlobalVariable(IDebugTarget target, IPath fileName, String name) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            ICDIVariableObject vo = null;
            try {
                vo = ((CDebugTarget)target).getCDISession().getVariableManager().getGlobalVariableObject(fileName.lastSegment(), null, name);
                ICDIVariable cdiVariable = ((CDebugTarget)target).getCDISession().getVariableManager().createVariable(vo);
                return new CExpression((CDebugTarget)target, (ICDIVariableObject)cdiVariable);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
            }
        }
        return null;
    }

    public static ICGlobalVariable createGlobalVariable(IDebugTarget target, IGlobalVariableDescriptor info) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            ICDIVariableObject vo = null;
            try {
                vo = ((CDebugTarget)target).getCDISession().getVariableManager().getGlobalVariableObject(info.getPath().lastSegment(), null, info.getName());
                ICDIVariable cdiVariable = ((CDebugTarget)target).getCDISession().getVariableManager().createVariable(vo);
                return new CGlobalVariable((CDebugElement)((CDebugTarget)target), cdiVariable);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
            }
        }
        return null;
    }
}

