/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSharedLibrary;
import org.eclipse.debug.core.DebugException;

public class CSharedLibraryManager
extends CUpdateManager
implements ICSharedLibraryManager {
    private ArrayList fSharedLibraries = new ArrayList(5);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSharedLibraryManager(CDebugTarget target) {
        super(target);
        boolean autoRefresh = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_SHARED_LIBRARIES_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(autoRefresh);
        }
    }

    public void sharedLibraryLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = new CSharedLibrary(this.getDebugTarget(), cdiLibrary);
        ArrayList arrayList = this.fSharedLibraries;
        synchronized (arrayList) {
            this.fSharedLibraries.add(library);
        }
        library.fireCreationEvent();
        if (library.areSymbolsLoaded()) {
            this.setBreakpoints();
        }
    }

    public synchronized void sharedLibraryUnloaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            ArrayList arrayList = this.fSharedLibraries;
            synchronized (arrayList) {
                this.fSharedLibraries.remove(library);
            }
            library.dispose();
            library.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDISharedLibrary cdiLibrary) {
        CSharedLibrary library = this.find(cdiLibrary);
        if (library != null) {
            library.fireChangeEvent(256);
            this.setBreakpoints();
        }
    }

    public ICSharedLibrary[] getSharedLibraries() {
        return this.fSharedLibraries.toArray(new ICSharedLibrary[this.fSharedLibraries.size()]);
    }

    public void dispose() {
        Iterator it = this.fSharedLibraries.iterator();
        while (it.hasNext()) {
            ((CSharedLibrary)it.next()).dispose();
        }
        this.fSharedLibraries.clear();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected CSharedLibrary find(ICDISharedLibrary cdiLibrary) {
        Iterator it = this.fSharedLibraries.iterator();
        while (it.hasNext()) {
            CSharedLibrary library = (CSharedLibrary)it.next();
            if (!library.getCDISharedLibrary().equals(cdiLibrary)) continue;
            return library;
        }
        return null;
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getSharedLibraryManager();
        }
        return null;
    }

    public void loadSymbols(ICSharedLibrary[] libraries) throws DebugException {
        ICDISharedLibraryManager slm = (ICDISharedLibraryManager)this.getCDIManager();
        if (slm != null) {
            ArrayList<ICDISharedLibrary> cdiLibs = new ArrayList<ICDISharedLibrary>(libraries.length);
            int i = 0;
            while (i < libraries.length) {
                cdiLibs.add(((CSharedLibrary)libraries[i]).getCDISharedLibrary());
                ++i;
            }
            try {
                slm.loadSymbols(cdiLibs.toArray(new ICDISharedLibrary[cdiLibs.size()]));
            }
            catch (CDIException e) {
                this.getDebugTarget().targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    public void loadSymbolsForAll() throws DebugException {
        ICDISharedLibraryManager slm = (ICDISharedLibraryManager)this.getCDIManager();
        if (slm != null) {
            try {
                slm.loadSymbols();
            }
            catch (CDIException e) {
                this.getDebugTarget().targetRequestFailed(e.getMessage(), null);
            }
        }
    }

    private void setBreakpoints() {
        this.getDebugTarget().setBreakpoints();
    }
}

