/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.GDBSolibBlock;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class GDBDebuggerPage
extends AbstractLaunchConfigurationTab
implements Observer {
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    private GDBSolibBlock fSolibBlock;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(MIUIMessages.getString("GDBDebuggerPage.0"));
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String gdbCommand = "gdb";
        String gdbInit = "";
        try {
            gdbCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            gdbInit = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        }
        catch (CoreException coreException) {}
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String gdbStr = this.fGDBCommandText.getText();
        gdbStr.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, gdbStr);
        gdbStr = this.fGDBInitText.getText();
        gdbStr.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, gdbStr);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public String getName() {
        return MIUIMessages.getString("GDBDebuggerPage.1");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        this.updateLaunchConfigurationDialog();
    }

    public GDBSolibBlock createSolibBlock(Composite parent) {
        GDBSolibBlock block = new GDBSolibBlock();
        block.createBlock(parent, true, true, true);
        return block;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("GDBDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBDebuggerPage.3"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(subComp, MIUIMessages.getString("GDBDebuggerPage.4"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBDebuggerPage.5"));
                String gdbCommand = GDBDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        button = this.createPushButton(subComp, MIUIMessages.getString("GDBDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBDebuggerPage.8"));
                String gdbCommand = GDBDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)comp, (String)MIUIMessages.getString("GDBDebuggerPage.9"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("GDBDebuggerPage.10"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        this.fSolibBlock.addObserver(this);
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            this.fSolibBlock.deleteObserver(this);
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }
}

