/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.BinaryParserConfig;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.IncludeReference;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.cdt.internal.core.model.LibraryReferenceArchive;
import org.eclipse.cdt.internal.core.model.LibraryReferenceShared;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CProject
extends Openable
implements ICProject {
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public CProject(ICElement parent, IProject project) {
        super(parent, (IResource)project, 11);
    }

    public IBinaryContainer getBinaryContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    public ICElement findElement(IPath path) throws CModelException {
        ICElement celem = null;
        if (path.isAbsolute()) {
            celem = CModelManager.getDefault().create(path);
        } else {
            IProject project = this.getProject();
            if (project != null) {
                IPath p = project.getFullPath().append(path);
                celem = CModelManager.getDefault().create(p);
            }
        }
        if (celem == null) {
            CModelStatus status = new CModelStatus(979, path);
            throw new CModelException(status);
        }
        return celem;
    }

    public static boolean hasCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasCCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isCProject() {
        return CProject.hasCNature(this.getProject()) || CProject.hasCCNature(this.getProject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CProject)) {
            return false;
        }
        CProject other = (CProject)o;
        return this.getProject().equals((Object)other.getProject());
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public IIncludeReference[] getIncludeReferences() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IIncludeReference[] incRefs = null;
        if (pinfo != null) {
            incRefs = pinfo.incReferences;
        }
        if (incRefs == null) {
            IPathEntry[] entries = this.getResolvedPathEntries();
            ArrayList<IncludeReference> list = new ArrayList<IncludeReference>(entries.length);
            int i = 0;
            while (i < entries.length) {
                IIncludeEntry entry;
                IncludeReference inc;
                if (entries[i].getEntryKind() == 4 && (inc = new IncludeReference(this, entry = (IIncludeEntry)entries[i])) != null) {
                    list.add(inc);
                }
                ++i;
            }
            incRefs = list.toArray(new IIncludeReference[0]);
            if (pinfo != null) {
                pinfo.incReferences = incRefs;
            }
        }
        return incRefs;
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ILibraryReference[] libRefs = null;
        if (pinfo != null) {
            libRefs = pinfo.libReferences;
        }
        if (libRefs == null) {
            BinaryParserConfig[] binConfigs = CModelManager.getDefault().getBinaryParser(this.getProject());
            IPathEntry[] entries = this.getResolvedPathEntries();
            ArrayList<ILibraryReference> list = new ArrayList<ILibraryReference>(entries.length);
            int i = 0;
            while (i < entries.length) {
                ILibraryEntry entry;
                ILibraryReference lib;
                if (entries[i].getEntryKind() == 1 && (lib = CProject.getLibraryReference(this, binConfigs, entry = (ILibraryEntry)entries[i])) != null) {
                    list.add(lib);
                }
                ++i;
            }
            libRefs = list.toArray(new ILibraryReference[0]);
            if (pinfo != null) {
                pinfo.libReferences = libRefs;
            }
        }
        return libRefs;
    }

    private static ILibraryReference getLibraryReference(ICProject cproject, BinaryParserConfig[] binConfigs, ILibraryEntry entry) {
        if (binConfigs == null) {
            binConfigs = CModelManager.getDefault().getBinaryParser(cproject.getProject());
        }
        Parent lib = null;
        if (binConfigs != null) {
            int i = 0;
            while (i < binConfigs.length) {
                try {
                    IBinaryParser.IBinaryFile bin = binConfigs[i].getBinaryParser().getBinary(entry.getFullLibraryPath());
                    if (bin != null) {
                        if (bin.getType() == 8) {
                            lib = new LibraryReferenceArchive((ICElement)cproject, entry, (IBinaryParser.IBinaryArchive)bin);
                            break;
                        }
                        if (!(bin instanceof IBinaryParser.IBinaryObject)) break;
                        lib = new LibraryReferenceShared((ICElement)cproject, entry, (IBinaryParser.IBinaryObject)bin);
                        break;
                    }
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        if (lib == null) {
            lib = new LibraryReference(cproject, entry);
        }
        return lib;
    }

    public String[] getRequiredProjectNames() throws CModelException {
        return this.projectPrerequisites(this.getResolvedPathEntries());
    }

    public String[] projectPrerequisites(IPathEntry[] entries) throws CModelException {
        return PathEntryManager.getDefault().projectPrerequisites(entries);
    }

    public String getOption(String optionName, boolean inheritCCoreOptions) {
        if (CModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(optionName)) {
                return inheritCCoreOptions ? CCorePlugin.getOption(optionName) : null;
            }
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritCCoreOptions) {
        String propertyName;
        int i;
        HashMap options = inheritCCoreOptions ? CCorePlugin.getOptions() : new HashMap(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = CModelManager.OptionNames;
        if (inheritCCoreOptions) {
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            i = 0;
            while (i < defaultPropertyNames.length) {
                propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName).trim());
                }
                ++i;
            }
        }
        String[] propertyNames = preferences.propertyNames();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            if (optionNames.contains(propertyName)) {
                options.put(propertyName, preferences.getString(propertyName).trim());
            }
            ++i;
        }
        return options;
    }

    public void setOption(String optionName, String optionValue) {
        if (!CModelManager.OptionNames.contains(optionName)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(optionName, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(optionName, optionValue);
        this.savePreferences(preferences);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!CModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    private Preferences getPreferences() {
        if (!this.isCProject()) {
            return null;
        }
        Preferences preferences = new Preferences();
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = this.resource.getPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName));
            }
            catch (CoreException coreException) {}
            if (value == null) continue;
            preferences.setValue(qualifiedName, value);
        }
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        if (!this.isCProject()) {
            return;
        }
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = preferences.getString(qualifiedName);
                if (value != null && !value.equals(preferences.getDefaultString(qualifiedName))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), value);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void setPreferences(Preferences preferences) {
        if (!this.isCProject()) {
            return;
        }
    }

    public IPathEntry[] getResolvedPathEntries() throws CModelException {
        return CoreModel.getResolvedPathEntries(this);
    }

    public IPathEntry[] getRawPathEntries() throws CModelException {
        return CoreModel.getRawPathEntries(this);
    }

    public void setRawPathEntries(IPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        CoreModel.setRawPathEntries(this, newEntries, monitor);
    }

    public ISourceRoot getSourceRoot(ISourceEntry entry) throws CModelException {
        IPath sp;
        IPath p = this.getPath();
        if (p.isPrefixOf(sp = entry.getPath())) {
            int count = sp.matchingFirstSegments(p);
            sp = sp.removeFirstSegments(count);
            Object res = null;
            res = sp.isEmpty() ? this.getProject() : this.getProject().findMember(sp);
            if (res != null) {
                return new SourceRoot((ICElement)this, (IResource)res, entry);
            }
        }
        return null;
    }

    public ISourceRoot[] getSourceRoots() throws CModelException {
        ICElement[] children = this.getChildren();
        int length = children.length;
        ISourceRoot[] roots = new ISourceRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public ISourceRoot[] getAllSourceRoots() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ISourceRoot[] roots = null;
        if (pinfo != null) {
            if (pinfo.sourceRoots != null) {
                roots = pinfo.sourceRoots;
            } else {
                pinfo.sourceRoots = this.computeSourceRoots().toArray(new ISourceRoot[this.computeSourceRoots().size()]);
                roots = pinfo.sourceRoots;
            }
        } else {
            roots = this.computeSourceRoots().toArray(new ISourceRoot[this.computeSourceRoots().size()]);
        }
        return roots;
    }

    public IOutputEntry[] getOutputEntries() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IOutputEntry[] outs = null;
        if (pinfo != null) {
            if (pinfo.outputEntries != null) {
                outs = pinfo.outputEntries;
            } else {
                IPathEntry[] entries = this.getResolvedPathEntries();
                pinfo.outputEntries = this.getOutputEntries(entries);
                outs = pinfo.outputEntries;
            }
        } else {
            IPathEntry[] entries = this.getResolvedPathEntries();
            outs = this.getOutputEntries(entries);
        }
        return outs;
    }

    public IOutputEntry[] getOutputEntries(IPathEntry[] entries) throws CModelException {
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 7) {
                list.add(entries[i]);
            }
            ++i;
        }
        IOutputEntry[] outputs = new IOutputEntry[list.size()];
        list.toArray(outputs);
        return outputs;
    }

    public boolean isOnOutputEntry(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2 || resource.getType() == 4) {
            path = path.append("*");
        }
        try {
            IOutputEntry[] entries = this.getOutputEntries();
            int i = 0;
            while (i < entries.length) {
                boolean on = this.isOnOutputEntry(entries[i], path);
                if (on) {
                    return on;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    private boolean isOnOutputEntry(IOutputEntry entry, IPath path) {
        return entry.getPath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, entry.fullExclusionPatternChars());
    }

    /*
     * Exception decompiling
     */
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List computeSourceRoots() throws CModelException {
        IPathEntry[] entries = this.getResolvedPathEntries();
        ArrayList<ISourceRoot> list = new ArrayList<ISourceRoot>(entries.length);
        int i = 0;
        while (i < entries.length) {
            ISourceEntry sourceEntry;
            ISourceRoot root;
            if (entries[i].getEntryKind() == 3 && (root = this.getSourceRoot(sourceEntry = (ISourceEntry)entries[i])) != null) {
                list.add(root);
            }
            ++i;
        }
        return list;
    }

    protected boolean computeSourceRoots(OpenableInfo info, IResource res) throws CModelException {
        info.setChildren(this.computeSourceRoots());
        if (info instanceof CProjectInfo) {
            CProjectInfo pinfo = (CProjectInfo)info;
            pinfo.setNonCResources(null);
        }
        return true;
    }

    public boolean isOnSourceRoot(ICElement element) {
        try {
            ISourceRoot[] roots = this.getSourceRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].isOnSourceEntry(element)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    public boolean isOnSourceRoot(IResource resource) {
        try {
            ISourceRoot[] roots = this.getSourceRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].isOnSourceEntry(resource)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    public boolean exists() {
        if (!this.isCProject()) {
            return false;
        }
        return super.exists();
    }

    public Object[] getNonCResources() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    protected void closing(Object info) throws CModelException {
        if (info instanceof CProjectInfo) {
            CProjectInfo pinfo = (CProjectInfo)info;
            if (pinfo.vBin != null) {
                pinfo.vBin.close();
            }
            if (pinfo.vLib != null) {
                pinfo.vLib.close();
            }
            pinfo.resetCaches();
            CModelManager.getDefault().removeBinaryRunner(this);
        }
        super.closing(info);
    }

    public void resetCaches() {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        if (pinfo != null) {
            pinfo.resetCaches();
        }
    }
}

