/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyBlock;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class Disassembly
extends CDebugElement
implements IDisassembly {
    private static final int DISASSEMBLY_BLOCK_SIZE = 100;
    private DisassemblyBlock[] fBlocks = new DisassemblyBlock[1];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Disassembly(CDebugTarget target) {
        super(target);
    }

    public IDisassemblyBlock getDisassemblyBlock(ICStackFrame frame) throws DebugException {
        if (this.fBlocks[0] == null || !this.fBlocks[0].contains(frame)) {
            this.fBlocks[0] = this.createBlock(frame);
        }
        return this.fBlocks[0];
    }

    private DisassemblyBlock createBlock(ICStackFrame frame) throws DebugException {
        ICDISourceManager sm;
        ICDISession session;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((session = (ICDISession)iDebugTarget.getAdapter((Class)clazz)) != null && (sm = session.getSourceManager()) != null) {
            String fileName = frame.getFile();
            int lineNumber = frame.getLineNumber();
            ICDIMixedInstruction[] mixedInstrs = new ICDIMixedInstruction[]{};
            long address = frame.getAddress();
            if (fileName != null && fileName.length() > 0) {
                try {
                    mixedInstrs = sm.getMixedInstructions(fileName, lineNumber, CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS));
                }
                catch (CDIException e) {
                    this.targetRequestFailed(e.getMessage(), e);
                }
            }
            if (mixedInstrs.length == 0 || !this.containsAddress(mixedInstrs, address)) {
                if (address >= 0L) {
                    try {
                        ICDIInstruction[] instructions = this.getFunctionInstructions(sm.getInstructions(address, address + 100L));
                        return DisassemblyBlock.create((IDisassembly)this, instructions);
                    }
                    catch (CDIException e) {
                        this.targetRequestFailed(e.getMessage(), e);
                    }
                }
            } else {
                return DisassemblyBlock.create((IDisassembly)this, mixedInstrs);
            }
        }
        return null;
    }

    private boolean containsAddress(ICDIMixedInstruction[] mi, long address) {
        int i = 0;
        while (i < mi.length) {
            ICDIInstruction[] instructions = mi[i].getInstructions();
            int j = 0;
            while (j < instructions.length) {
                if (instructions[j].getAdress() == address) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ICDIInstruction[] getFunctionInstructions(ICDIInstruction[] rawInstructions) {
        if (rawInstructions.length > 0 && rawInstructions[0].getFuntionName() != null && rawInstructions[0].getFuntionName().length() > 0) {
            ArrayList<ICDIInstruction> list = new ArrayList<ICDIInstruction>(rawInstructions.length);
            list.add(rawInstructions[0]);
            int i = 1;
            while (i < rawInstructions.length) {
                if (rawInstructions[0].getFuntionName().equals(rawInstructions[i].getFuntionName())) {
                    list.add(rawInstructions[i]);
                }
                ++i;
            }
            return list.toArray(new ICDIInstruction[list.size()]);
        }
        return rawInstructions;
    }

    public void dispose() {
        int i = 0;
        while (i < this.fBlocks.length) {
            if (this.fBlocks[i] != null) {
                this.fBlocks[i].dispose();
                this.fBlocks[i] = null;
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void reset() {
        int i = 0;
        while (i < this.fBlocks.length) {
            if (this.fBlocks[i] != null) {
                this.fBlocks[i].dispose();
                this.fBlocks[i] = null;
            }
            ++i;
        }
        this.fireChangeEvent(512);
    }
}

