/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    protected Button fStopInMain;
    protected Button fAttachButton;
    protected Button fRunButton;
    protected Button fVarBookKeeping;
    private final boolean DEFAULT_STOP_AT_MAIN = true;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_debugger_tab");
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Composite comboComp = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        Label dlabel = new Label(comboComp, 0);
        dlabel.setText(LaunchUIPlugin.getResourceString("Launch.common.DebuggerColon"));
        this.fDCombo = new Combo(comboComp, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDebuggerTab.this.updateComboFromSelection();
            }
        });
        Composite radioComp = new Composite(comp, 0);
        GridLayout radioLayout = new GridLayout(2, true);
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioComp.setLayout((Layout)radioLayout);
        this.fRunButton = this.createRadioButton(radioComp, LaunchUIPlugin.getResourceString("CDebuggerTab.Run_program_in_debugger"));
        this.fRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDebuggerTab.this.fRunButton.getSelection()) {
                    CDebuggerTab.this.fStopInMain.setEnabled(true);
                } else {
                    CDebuggerTab.this.fStopInMain.setEnabled(false);
                }
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAttachButton = this.createRadioButton(radioComp, LaunchUIPlugin.getResourceString("CDebuggerTab.Attach_to_running_process"));
        this.fAttachButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite optionComp = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        optionComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        optionComp.setLayoutData((Object)gd);
        this.fStopInMain = new Button(optionComp, 32);
        this.fStopInMain.setText(LaunchUIPlugin.getResourceString("CDebuggerTab.Stop_at_main_on_startup"));
        this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fVarBookKeeping = new Button(optionComp, 32);
        this.fVarBookKeeping.setText(LaunchUIPlugin.getResourceString("CDebuggerTab.Automatically_track_values_of_variables"));
        this.fVarBookKeeping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group debuggerGroup = new Group(comp, 16);
        debuggerGroup.setText(LaunchUIPlugin.getResourceString("CDebuggerTab.Debugger_Options"));
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        String configPlatform = this.getPlatform(config);
        String programCPU = "native";
        ICElement ce = this.getContext(config, configPlatform);
        if (ce instanceof IBinary) {
            IBinary bin = (IBinary)ce;
            programCPU = bin.getCPU();
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        Arrays.sort(debugConfigs, new Comparator(){

            public int compare(Object o1, Object o2) {
                ICDebugConfiguration ic1 = (ICDebugConfiguration)o1;
                ICDebugConfiguration ic2 = (ICDebugConfiguration)o2;
                return ic1.getName().compareTo(ic2.getName());
            }
        });
        int x = 0;
        int selndx = -1;
        int i = 0;
        while (i < debugConfigs.length) {
            String debuggerPlatform;
            if ((debugConfigs[i].supportsMode("run") || debugConfigs[i].supportsMode("attach")) && ((debuggerPlatform = debugConfigs[i].getPlatform()).equalsIgnoreCase(configPlatform) || debuggerPlatform.equalsIgnoreCase("*")) && debugConfigs[i].supportsCPU(programCPU)) {
                this.fDCombo.add(debugConfigs[i].getName());
                this.fDCombo.setData(Integer.toString(x), (Object)debugConfigs[i]);
                if (selndx == -1 && debuggerPlatform.equalsIgnoreCase(configPlatform) || selection.equals(debugConfigs[i].getID())) {
                    selndx = x;
                }
                ++x;
            }
            ++i;
        }
        this.setInitializeDefault(selection.equals(""));
        this.fDCombo.select(selndx == -1 ? 0 : selndx);
        this.updateComboFromSelection();
        this.getControl().getParent().layout(true);
    }

    protected void updateComboFromSelection() {
        this.handleDebuggerChanged();
        ICDebugConfiguration debugConfig = this.getConfigForCurrentDebugger();
        if (debugConfig != null) {
            this.fRunButton.setEnabled(debugConfig.supportsMode("run"));
            this.fRunButton.setSelection(false);
            this.fAttachButton.setEnabled(debugConfig.supportsMode("attach"));
            this.fAttachButton.setSelection(false);
            try {
                String mode = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (mode.equals("run") && this.fRunButton.isEnabled()) {
                    this.fRunButton.setSelection(true);
                } else if (mode.equals("attach") && this.fAttachButton.isEnabled()) {
                    this.fAttachButton.setSelection(true);
                }
                if (this.fRunButton.getSelection()) {
                    this.fStopInMain.setEnabled(true);
                } else {
                    this.fStopInMain.setEnabled(false);
                }
            }
            catch (CoreException coreException) {}
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        try {
            String id = workingCopy.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox((ILaunchConfiguration)workingCopy, id);
        }
        catch (CoreException coreException) {}
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id);
            String mode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (mode.equals("run")) {
                this.fRunButton.setSelection(true);
                this.fAttachButton.setSelection(false);
            } else if (mode.equals("attach")) {
                this.fAttachButton.setSelection(true);
                this.fRunButton.setSelection(false);
            }
            if (config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true)) {
                this.fStopInMain.setSelection(true);
            }
            if (!config.getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false)) {
                this.fVarBookKeeping.setSelection(true);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.isValid((ILaunchConfiguration)config)) {
            super.performApply(config);
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", !this.fVarBookKeeping.getSelection());
            if (this.fAttachButton.getSelection()) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
            } else {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CDebuggerTab.No_debugger_available"));
            return false;
        }
        if (!super.isValid(config)) {
            return false;
        }
        if (!this.fRunButton.getSelection() && !this.fAttachButton.getSelection()) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CDebuggerTab.Select_Debug_mode"));
            return false;
        }
        return true;
    }

    private boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig;
        ICElement ce = this.getContext(config, null);
        String projectPlatform = this.getPlatform(config);
        String projectCPU = "native";
        if (ce != null && ce instanceof IBinary) {
            IBinary bin = (IBinary)ce;
            projectCPU = bin.getCPU();
        }
        if ((debugConfig = this.getDebugConfig()) == null) {
            return false;
        }
        String debuggerPlatform = debugConfig.getPlatform();
        return (debuggerPlatform.equalsIgnoreCase(projectPlatform) || debuggerPlatform.equalsIgnoreCase("*")) && debugConfig.supportsCPU(projectCPU);
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

