/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast;

import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;

public class ASTMacro
implements IASTMacro {
    private int nameEndOffset = 0;
    private final String name;
    private final IMacroDescriptor innerMacro;
    private int startingOffset = 0;
    private int endingOffset = 0;
    private int nameOffset = 0;
    private int startingLineNumber;
    private int endingLineNumber;
    private int nameLineNumber;
    private int fileIndex;

    public ASTMacro(String name, IMacroDescriptor info, int start, int startLine, int nameBeg, int nameEnd, int nameLine, int end, int endLine) {
        this.name = name;
        this.setStartingOffsetAndLineNumber(start, startLine);
        this.setNameOffset(nameBeg);
        this.setNameEndOffsetAndLineNumber(nameEnd, nameLine);
        this.setEndingOffsetAndLineNumber(end, endLine);
        this.innerMacro = info;
    }

    public String getName() {
        return this.name;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public void setNameOffset(int o) {
        this.nameOffset = o;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptMacro(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return this.innerMacro.getMacroType();
    }

    public String[] getParameters() {
        return this.innerMacro.getParameters();
    }

    public IToken[] getTokenizedExpansion() {
        return this.innerMacro.getTokenizedExpansion();
    }

    public String getCompleteSignature() {
        return this.innerMacro.getCompleteSignature();
    }

    public String getExpansionSignature() {
        return this.innerMacro.getExpansionSignature();
    }

    public boolean compatible(IMacroDescriptor descriptor) {
        return this.innerMacro.compatible(descriptor);
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public boolean isCircular() {
        return this.innerMacro.isCircular();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int index) {
        this.fileIndex = index;
    }
}

