/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTTypedef
extends ASTSymbol
implements IASTTypedefDeclaration {
    private final IASTAbstractDeclaration mapping;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;

    public ASTTypedef(ISymbol newSymbol, IASTAbstractDeclaration mapping, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references) {
        super(newSymbol);
        this.mapping = mapping;
        this.references = references;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), newSymbol.getName());
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public IASTAbstractDeclaration getAbstractDeclarator() {
        return this.mapping;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptTypedefDeclaration(this);
        }
        catch (Exception exception) {}
        manager.processReferences(this.references, requestor);
        this.references = null;
        this.getAbstractDeclarator().acceptElement(requestor, manager);
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public IASTTypeSpecifier getFinalTypeSpecifier() throws ASTNotImplementedException {
        IASTTypeSpecifier currentTypeSpec = this.mapping.getTypeSpecifier();
        while (currentTypeSpec instanceof IASTSimpleTypeSpecifier || currentTypeSpec instanceof IASTTypedefDeclaration) {
            if (currentTypeSpec instanceof IASTSimpleTypeSpecifier) {
                IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)currentTypeSpec;
                if (simpleTypeSpec.getType() != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) break;
                currentTypeSpec = simpleTypeSpec.getTypeSpecifier();
                continue;
            }
            if (!(currentTypeSpec instanceof IASTTypedefDeclaration)) continue;
            currentTypeSpec = ((IASTTypedefDeclaration)currentTypeSpec).getAbstractDeclarator().getTypeSpecifier();
        }
        return currentTypeSpec;
    }
}

