/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class SpecializedSymbol
extends TemplateSymbol
implements ISpecializedSymbol {
    private List _argumentList = Collections.EMPTY_LIST;
    private ITemplateSymbol _primaryTemplate;

    protected SpecializedSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected SpecializedSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    public Object clone() {
        SpecializedSymbol copy = (SpecializedSymbol)super.clone();
        copy._argumentList = this._argumentList != Collections.EMPTY_LIST ? (List)((ArrayList)this._argumentList).clone() : this._argumentList;
        return copy;
    }

    public ITemplateSymbol getPrimaryTemplate() {
        return this._primaryTemplate;
    }

    public void setPrimaryTemplate(ITemplateSymbol templateSymbol) {
        this._primaryTemplate = templateSymbol;
    }

    public ISymbol instantiate(List arguments) throws ParserSymbolTableException {
        HashMap<ISymbol, TypeInfo> argMap = new HashMap<ISymbol, TypeInfo>();
        List specArgs = this.getArgumentList();
        if (specArgs.size() != arguments.size()) {
            return null;
        }
        ArrayList<TypeInfo> actualArgs = new ArrayList<TypeInfo>(specArgs.size());
        ISymbol templatedSymbol = this.getTemplatedSymbol();
        while (templatedSymbol.isTemplateInstance()) {
            templatedSymbol = templatedSymbol.getInstantiatedSymbol();
        }
        int numSpecArgs = specArgs.size();
        int i = 0;
        while (i < numSpecArgs) {
            TypeInfo info = (TypeInfo)specArgs.get(i);
            TypeInfo mappedInfo = (TypeInfo)arguments.get(i);
            if (mappedInfo.isType(TypeInfo.t_type) && mappedInfo.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                return this.deferredInstance(arguments);
            }
            actualArgs.add(mappedInfo);
            if (info.isType(TypeInfo.t_type) && info.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                ISymbol param = info.getTypeSymbol();
                if (!argMap.containsKey(param = TemplateEngine.translateParameterForDefinition(templatedSymbol, param, this.getDefinitionParameterMap()))) {
                    argMap.put(param, mappedInfo);
                }
            }
            ++i;
        }
        if (this.getParameterList().size() != argMap.size()) {
            return null;
        }
        List params = this.getParameterList();
        int numParams = params.size();
        int i2 = 0;
        while (i2 < numParams) {
            if (!argMap.containsKey(params.get(i2))) {
                return null;
            }
            ++i2;
        }
        IContainerSymbol instance = this.findInstantiation(actualArgs);
        if (instance != null) {
            return instance;
        }
        ISymbol symbol = null;
        if (this.getContainedSymbols().size() == 1) {
            Iterator iter = this.getContainedSymbols().keySet().iterator();
            symbol = (IContainerSymbol)this.getContainedSymbols().get(iter.next());
        }
        instance = (IContainerSymbol)symbol.instantiate(this, argMap);
        this.addInstantiation(instance, actualArgs);
        try {
            this.processDeferredInstantiations();
        }
        catch (ParserSymbolTableException e) {
            if (e.reason == 11) {
                this.removeInstantiation(instance);
            }
            throw e;
        }
        return instance;
    }

    public List getArgumentList() {
        return this._argumentList;
    }

    public void prepareArguments(int size) {
        if (this._argumentList == Collections.EMPTY_LIST) {
            this._argumentList = new ArrayList(size);
        } else {
            ((ArrayList)this._argumentList).ensureCapacity(size);
        }
    }

    public void addArgument(TypeInfo arg) {
        if (this._argumentList == Collections.EMPTY_LIST) {
            this._argumentList = new ArrayList(4);
        }
        this._argumentList.add(arg);
    }
}

