/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayMap;

public class CharArrayObjectMap
extends CharArrayMap {
    private Object[] valueTable = new Object[this.capacity()];

    public CharArrayObjectMap(int initialSize) {
        super(initialSize);
    }

    protected void resize(int size) {
        super.resize(size);
        Object[] oldValueTable = this.valueTable;
        this.valueTable = new Object[size];
        System.arraycopy(oldValueTable, 0, this.valueTable, 0, oldValueTable.length);
    }

    public Object put(char[] key, int start, int length, Object value) {
        int i = this.add(key, start, length);
        Object oldvalue = this.valueTable[i];
        this.valueTable[i] = value;
        return oldvalue;
    }

    public Object put(char[] key, Object value) {
        return this.put(key, 0, key.length, value);
    }

    public Object get(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return null;
    }

    public Object get(char[] key) {
        return this.get(key, 0, key.length);
    }

    public Object remove(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i < 0) {
            return null;
        }
        Object value = this.valueTable[i];
        this.removeEntry(i);
        return value;
    }

    public Object remove(char[] key) {
        return this.remove(key, 0, key.length);
    }

    protected void removeEntry(int i) {
        if (i < this.currEntry) {
            System.arraycopy(this.valueTable, i + 1, this.valueTable, i, this.currEntry - i);
        }
        this.valueTable[this.currEntry] = null;
        super.removeEntry(i);
    }
}

