/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.event.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.CreatedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DisconnectedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.MemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MICreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));
    List tokenList = new ArrayList(1);
    MIRunningEvent lastRunningEvent;
    Command lastUserCommand = null;

    public void update(Observable o, Object arg) {
        MIEvent miEvent = (MIEvent)arg;
        Session session = (Session)this.getSession();
        ArrayList<Object> cdiList = new ArrayList<Object>(1);
        if (!this.ignoreEventToken(miEvent.getToken())) {
            MIEvent bpoint;
            if (miEvent instanceof MIStoppedEvent) {
                if (this.processSuspendedEvent((MIStoppedEvent)miEvent)) {
                    cdiList.add(new SuspendedEvent(session, miEvent));
                }
            } else if (miEvent instanceof MIRunningEvent) {
                if (this.processRunningEvent((MIRunningEvent)miEvent)) {
                    cdiList.add(new ResumedEvent(session, (MIRunningEvent)miEvent));
                }
            } else if (miEvent instanceof MIChangedEvent) {
                if (miEvent instanceof MIVarChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MIVarChangedEvent)miEvent));
                } else if (miEvent instanceof MIRegisterChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MIRegisterChangedEvent)miEvent));
                } else if (miEvent instanceof MIMemoryChangedEvent) {
                    MemoryManager mgr = (MemoryManager)session.getMemoryManager();
                    MemoryBlock[] blocks = mgr.listMemoryBlocks();
                    MIMemoryChangedEvent miMem = (MIMemoryChangedEvent)miEvent;
                    Long[] addresses = miMem.getAddresses();
                    int i = 0;
                    while (i < blocks.length) {
                        if (blocks[i].contains(addresses) && (!blocks[i].isFrozen() || blocks[i].isDirty())) {
                            cdiList.add(new MemoryChangedEvent(session, blocks[i], miMem));
                            blocks[i].setDirty(false);
                        }
                        ++i;
                    }
                } else if (miEvent instanceof MIBreakpointChangedEvent) {
                    bpoint = (MIBreakpointChangedEvent)miEvent;
                    if (((MIBreakpointChangedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new ChangedEvent(session, (MIBreakpointChangedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MISharedLibChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MISharedLibChangedEvent)miEvent));
                } else if (miEvent instanceof MISignalChangedEvent) {
                    MISignalChangedEvent sig = (MISignalChangedEvent)miEvent;
                    String name = sig.getName();
                    if (name == null || name.length() == 0) {
                        try {
                            session.getSignalManager().update();
                        }
                        catch (CDIException cDIException) {}
                    } else {
                        cdiList.add(new ChangedEvent(session, sig));
                    }
                }
            } else if (miEvent instanceof MIDestroyedEvent) {
                if (miEvent instanceof MIThreadExitEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIThreadExitEvent)miEvent));
                } else if (miEvent instanceof MIInferiorSignalExitEvent) {
                    cdiList.add(new ExitedEvent(session, (MIInferiorSignalExitEvent)miEvent));
                } else if (miEvent instanceof MIInferiorExitEvent) {
                    cdiList.add(new ExitedEvent(session, (MIInferiorExitEvent)miEvent));
                } else if (miEvent instanceof MIGDBExitEvent) {
                    cdiList.add(new DestroyedEvent(session));
                } else if (miEvent instanceof MIDetachedEvent) {
                    cdiList.add(new DisconnectedEvent(session));
                } else if (miEvent instanceof MIBreakpointDeletedEvent) {
                    bpoint = (MIBreakpointDeletedEvent)miEvent;
                    if (((MIBreakpointDeletedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new DestroyedEvent(session, (MIBreakpointDeletedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MISharedLibUnloadedEvent) {
                    cdiList.add(new DestroyedEvent(session, (MISharedLibUnloadedEvent)miEvent));
                } else if (miEvent instanceof MIVarDeletedEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIVarDeletedEvent)miEvent));
                }
            } else if (miEvent instanceof MICreatedEvent) {
                if (miEvent instanceof MIBreakpointCreatedEvent) {
                    bpoint = (MIBreakpointCreatedEvent)miEvent;
                    if (((MIBreakpointCreatedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new CreatedEvent(session, (MIBreakpointCreatedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MIVarCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIVarCreatedEvent)miEvent));
                } else if (miEvent instanceof MIRegisterCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIRegisterCreatedEvent)miEvent));
                } else if (miEvent instanceof MIThreadCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIThreadCreatedEvent)miEvent));
                } else if (miEvent instanceof MIMemoryCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIMemoryCreatedEvent)miEvent));
                } else if (miEvent instanceof MISharedLibCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MISharedLibCreatedEvent)miEvent));
                }
            }
        }
        ICDIEvent[] cdiEvents = cdiList.toArray(new ICDIEvent[0]);
        this.fireEvents(cdiEvents);
    }

    public EventManager(Session session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(ICDIEventListener listener) {
        this.list.remove(listener);
    }

    private void fireEvents(ICDIEvent[] cdiEvents) {
        if (cdiEvents != null && cdiEvents.length > 0) {
            ICDIEventListener[] listeners = this.list.toArray(new ICDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvents(cdiEvents);
                ++i;
            }
        }
    }

    boolean processSuspendedEvent(MIStoppedEvent stopped) {
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        if (this.processSharedLibEvent(stopped)) {
            return false;
        }
        int threadId = stopped.getThreadId();
        if (currentTarget instanceof Target) {
            Target cTarget = (Target)currentTarget;
            cTarget.updateState(threadId);
            try {
                ICDIThread cthread = cTarget.getCurrentThread();
                if (cthread == null) {
                    return true;
                }
                cthread.getCurrentStackFrame();
            }
            catch (CDIException cDIException) {
                return true;
            }
        }
        ICDIVariableManager varMgr = session.getVariableManager();
        ICDIExpressionManager expMgr = session.getExpressionManager();
        ICDIRegisterManager regMgr = session.getRegisterManager();
        ICDIMemoryManager memMgr = session.getMemoryManager();
        ICDIBreakpointManager bpMgr = session.getBreakpointManager();
        ICDISignalManager sigMgr = session.getSignalManager();
        ICDISourceManager srcMgr = session.getSourceManager();
        ICDISharedLibraryManager libMgr = session.getSharedLibraryManager();
        try {
            if (varMgr.isAutoUpdate()) {
                varMgr.update();
            }
            if (expMgr.isAutoUpdate()) {
                expMgr.update();
            }
            if (regMgr.isAutoUpdate()) {
                regMgr.update();
            }
            if (memMgr.isAutoUpdate()) {
                memMgr.update();
            }
            if (bpMgr.isAutoUpdate()) {
                bpMgr.update();
            }
            if (sigMgr.isAutoUpdate()) {
                sigMgr.update();
            }
            if (libMgr.isAutoUpdate()) {
                libMgr.update();
            }
            if (srcMgr.isAutoUpdate()) {
                srcMgr.update();
            }
        }
        catch (CDIException cDIException) {}
        return true;
    }

    boolean processSharedLibEvent(MIStoppedEvent stopped) {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDISharedLibraryManager libMgr = session.getSharedLibraryManager();
        SharedLibraryManager mgr = null;
        if (libMgr instanceof SharedLibraryManager) {
            mgr = (SharedLibraryManager)libMgr;
        }
        if (mgr != null && mgr.isDeferredBreakpoint()) {
            if (stopped instanceof MISharedLibEvent) {
                int type;
                List eventList = null;
                try {
                    eventList = mgr.updateState();
                }
                catch (CDIException cDIException) {
                    eventList = Collections.EMPTY_LIST;
                }
                if (eventList.size() > 0) {
                    ICDIBreakpointManager manager = session.getBreakpointManager();
                    if (manager instanceof BreakpointManager) {
                        BreakpointManager bpMgr = (BreakpointManager)manager;
                        ICDIBreakpoint[] bpoints = null;
                        try {
                            bpoints = bpMgr.getDeferredBreakpoints();
                        }
                        catch (CDIException cDIException) {
                            bpoints = new ICDIBreakpoint[]{};
                        }
                        int i = 0;
                        while (i < bpoints.length) {
                            if (bpoints[i] instanceof Breakpoint) {
                                Breakpoint bkpt = (Breakpoint)bpoints[i];
                                try {
                                    boolean enable = bkpt.isEnabled();
                                    bpMgr.setLocationBreakpoint(bkpt);
                                    bpMgr.deleteFromDeferredList(bkpt);
                                    bpMgr.addToBreakpointList(bkpt);
                                    if (!enable) {
                                        bpMgr.disableBreakpoint((ICDIBreakpoint)bkpt);
                                    }
                                    eventList.add(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
                                }
                                catch (CDIException cDIException) {}
                            }
                            ++i;
                        }
                    }
                    MIEvent[] events = eventList.toArray(new MIEvent[0]);
                    mi.fireEvents(events);
                }
                CommandFactory factory = mi.getCommandFactory();
                int n = type = this.lastRunningEvent == null ? 0 : this.lastRunningEvent.getType();
                if (this.lastUserCommand == null) {
                    switch (type) {
                        case 1: {
                            this.lastUserCommand = factory.createMIExecNext();
                            break;
                        }
                        case 2: {
                            this.lastUserCommand = factory.createMIExecNextInstruction();
                            break;
                        }
                        case 3: {
                            this.lastUserCommand = factory.createMIExecStep();
                            break;
                        }
                        case 4: {
                            this.lastUserCommand = factory.createMIExecStepInstruction();
                            break;
                        }
                        case 5: {
                            this.lastUserCommand = factory.createMIExecFinish();
                            break;
                        }
                        case 7: {
                            this.lastUserCommand = factory.createMIExecReturn();
                            break;
                        }
                        case 0: {
                            MIExecContinue cont = factory.createMIExecContinue();
                            try {
                                mi.postCommand(cont);
                                MIInfo info = cont.getMIInfo();
                            }
                            catch (MIException mIException) {}
                            return true;
                        }
                    }
                }
                int miLevel = 0;
                int tid = 0;
                ICDIThread currentThread = null;
                try {
                    currentThread = currentTarget.getCurrentThread();
                }
                catch (CDIException cDIException) {}
                if (currentThread instanceof Thread) {
                    tid = ((Thread)currentThread).getId();
                }
                if (tid > 0) {
                    MIThreadSelect selectThread = factory.createMIThreadSelect(tid);
                    try {
                        mi.postCommand(selectThread);
                    }
                    catch (MIException mIException) {}
                }
                ICDIStackFrame frame = null;
                try {
                    frame = currentThread.getCurrentStackFrame();
                }
                catch (CDIException cDIException) {}
                int count = 0;
                try {
                    MIStackInfoDepth depth = factory.createMIStackInfoDepth();
                    mi.postCommand(depth);
                    MIStackInfoDepthInfo info = depth.getMIStackInfoDepthInfo();
                    count = info.getDepth();
                }
                catch (MIException mIException) {}
                if (frame != null) {
                    miLevel = count - frame.getLevel() - 1;
                }
                if (miLevel >= 0) {
                    MIStackSelectFrame selectFrame = factory.createMIStackSelectFrame(miLevel);
                    MIExecFinish finish = factory.createMIExecFinish();
                    try {
                        mi.postCommand(selectFrame);
                        mi.postCommand(finish);
                    }
                    catch (MIException mIException) {}
                } else {
                    Command cmd = this.lastUserCommand;
                    this.lastUserCommand = null;
                    try {
                        mi.postCommand(cmd);
                    }
                    catch (MIException mIException) {}
                }
                return true;
            }
            if (this.lastUserCommand != null) {
                Command cmd = this.lastUserCommand;
                this.lastUserCommand = null;
                try {
                    mi.postCommand(cmd);
                }
                catch (MIException mIException) {}
                return true;
            }
        }
        return false;
    }

    boolean processRunningEvent(MIRunningEvent running) {
        this.lastRunningEvent = running;
        return true;
    }

    void disableEventToken(int token) {
        this.tokenList.add(new Integer(token));
    }

    void disableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.disableEventToken(tokens[i]);
            ++i;
        }
    }

    void enableEventToken(int token) {
        Integer t = new Integer(token);
        if (this.tokenList.contains(t)) {
            this.tokenList.remove(t);
        }
    }

    void enableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.enableEventToken(tokens[i]);
            ++i;
        }
    }

    private boolean ignoreEventToken(int token) {
        return this.tokenList.contains(new Integer(token));
    }
}

