/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ManageDefinedSymbolsDialog
extends Dialog {
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREFIX = "ManageDefinedSymbolsDialog";
    private static final String DIALOG_TITLE = "ManageDefinedSymbolsDialog.title";
    private static final String USER_GROUP = "ManageDefinedSymbolsDialog.userGroup.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String EDIT = "BuildPropertyCommon.label.edit";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol";
    private static final String EDIT_SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol.edit";
    private static final String SYMBOL_LABEL = "BuildPathInfoBlock.browse.symbol.label";
    private static final String DISCOVERED_GROUP = "ManageDefinedSymbolsDialog.discoveredGroup.title";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String SELECTED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.selected.label";
    private static final String REMOVED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.removed.label";
    private static final String REMOVE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.remove.label";
    private static final String RESTORE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.restore.label";
    private static final String DELETE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String DELETE_ALL_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.deleteAll.label";
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 40;
    private static final int ACTIVE = 0;
    private static final int REMOVED = 1;
    private static final int DO_REMOVE = 0;
    private static final int DO_RESTORE = 1;
    boolean alreadyCreated;
    private ArrayList returnSymbols;
    private ArrayList deletedDiscoveredSymbols;
    private LinkedHashMap discoveredSymbols;
    private LinkedHashMap workingDiscoveredSymbols;
    private boolean fDirty;
    private boolean fWorkingDirty;
    private ICOptionContainer fContainer;
    private IProject fProject;
    private Shell fShell;
    private MessageLine fStatusLine;
    private Group discoveredGroup;
    private Label selectedLabel;
    private Label removedLabel;
    private org.eclipse.swt.widgets.List discActiveList;
    private org.eclipse.swt.widgets.List discRemovedList;
    private Button removeDiscSymbol;
    private Button restoreDiscSymbol;
    private Button deleteDiscSymbol;
    private Button deleteAllDiscSymbols;

    protected ManageDefinedSymbolsDialog(Shell parentShell, ICOptionContainer container) {
        super(parentShell);
        DiscoveredPathInfo scanInfo;
        this.fShell = parentShell;
        this.fContainer = container;
        this.fProject = this.fContainer.getProject();
        if (this.fProject != null) {
            try {
                scanInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            }
            catch (CoreException coreException) {
                scanInfo = new DiscoveredPathInfo(this.fProject);
            }
        } else {
            scanInfo = new DiscoveredPathInfo(this.fProject);
        }
        this.discoveredSymbols = scanInfo.getSymbolMap();
        this.setDirty(false);
        this.fDirty = false;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(newShell);
    }

    private String getTitle(String title) {
        return MakeUIPlugin.getResourceString(title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setDirty(false);
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        this.initializeDialogUnits((Control)composite);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fStatusLine.setLayoutData(gd);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createOptionsControls(composite);
        this.createDiscoveredControls(composite);
        this.setListContents();
        this.discActiveList.select(0);
        this.enableDiscoveredButtons();
        return composite;
    }

    private void setListContents() {
        this.workingDiscoveredSymbols = new LinkedHashMap(this.discoveredSymbols);
        this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
        this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
    }

    private String[] getDiscDefinedSymbols(Map dSymbols, int type) {
        ArrayList aSymbols = new ArrayList();
        Iterator i = dSymbols.keySet().iterator();
        while (i.hasNext()) {
            String symbol = (String)i.next();
            SymbolEntry values = (SymbolEntry)dSymbols.get(symbol);
            List aValues = type == 0 ? values.getActiveRaw() : values.getRemovedRaw();
            aSymbols.addAll(aValues);
        }
        return aSymbols.toArray(new String[aSymbols.size()]);
    }

    private String[] getIncludes(Preferences prefs) {
        String syms = prefs.getString(PREF_SYMBOLS);
        return this.parseStringToList(syms);
    }

    private String[] parseStringToList(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    private void createOptionsControls(Composite composite) {
    }

    private void createDiscoveredControls(Composite composite) {
        this.discoveredGroup = ControlFactory.createGroup((Composite)composite, (String)this.getTitle(DISCOVERED_GROUP), (int)3);
        ((GridData)this.discoveredGroup.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.discoveredGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        Group c1 = this.discoveredGroup;
        this.selectedLabel = ControlFactory.createLabel((Composite)c1, (String)this.getTitle(SELECTED_LABEL));
        ((GridData)this.selectedLabel.getLayoutData()).horizontalSpan = 1;
        ControlFactory.createLabel((Composite)this.discoveredGroup, (String)"");
        this.removedLabel = ControlFactory.createLabel((Composite)c1, (String)this.getTitle(REMOVED_LABEL));
        ((GridData)this.removedLabel.getLayoutData()).horizontalSpan = 1;
        this.discActiveList = new org.eclipse.swt.widgets.List((Composite)c1, 2820);
        this.discActiveList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.discRemovedList.deselectAll();
                ManageDefinedSymbolsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        gd.heightHint = ManageDefinedSymbolsDialog.getDefaultFontHeight((Control)this.discActiveList, 15);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.discActiveList.setLayoutData((Object)gd);
        Composite pathButtonComp = ControlFactory.createComposite((Composite)this.discoveredGroup, (int)1);
        this.removeDiscSymbol = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(REMOVE_DISCOVERED));
        this.removeDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.handleRemoveRestoreDiscSymbol(0);
            }
        });
        this.removeDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.removeDiscSymbol);
        this.restoreDiscSymbol = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(RESTORE_DISCOVERED));
        this.restoreDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.handleRemoveRestoreDiscSymbol(1);
            }
        });
        this.restoreDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.restoreDiscSymbol);
        ControlFactory.createSeparator((Composite)pathButtonComp, (int)1);
        this.deleteDiscSymbol = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(DELETE_DISCOVERED));
        this.deleteDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.handleDeleteDiscSymbol();
            }
        });
        this.deleteDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteDiscSymbol);
        this.deleteAllDiscSymbols = ControlFactory.createPushButton((Composite)pathButtonComp, (String)this.getTitle(DELETE_ALL_DISCOVERED));
        this.deleteAllDiscSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.handleDeleteAllDiscSymbols();
            }
        });
        this.deleteAllDiscSymbols.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteAllDiscSymbols);
        Group c2 = this.discoveredGroup;
        this.discRemovedList = new org.eclipse.swt.widgets.List((Composite)c2, 2820);
        this.discRemovedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDefinedSymbolsDialog.this.discActiveList.deselectAll();
                ManageDefinedSymbolsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gd2 = new GridData(1808);
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 1;
        gd2.heightHint = ManageDefinedSymbolsDialog.getDefaultFontHeight((Control)this.discRemovedList, 15);
        gd2.widthHint = this.convertWidthInCharsToPixels(40);
        this.discRemovedList.setLayoutData((Object)gd2);
    }

    protected void handleRemoveRestoreDiscSymbol(int type) {
        if (this.workingDiscoveredSymbols != null) {
            int id;
            org.eclipse.swt.widgets.List discList = this.discRemovedList;
            org.eclipse.swt.widgets.List discOtherList = this.discActiveList;
            boolean newStatus = true;
            if (type == 0) {
                discList = this.discActiveList;
                discOtherList = this.discRemovedList;
                newStatus = false;
            }
            if ((id = discList.getSelectionIndex()) != -1) {
                String symbol = discList.getItem(id);
                String key = ScannerConfigUtil.getSymbolKey((String)symbol);
                String value = ScannerConfigUtil.getSymbolValue((String)symbol);
                SymbolEntry se = (SymbolEntry)this.workingDiscoveredSymbols.get(key);
                if (se != null) {
                    se = new SymbolEntry(se);
                    se.replace(value, newStatus);
                    this.workingDiscoveredSymbols.put(key, se);
                    this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
                    this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
                    discOtherList.setSelection(discOtherList.indexOf(symbol));
                    this.enableDiscoveredButtons();
                    this.setDirty(true);
                }
            }
        }
    }

    protected void handleDeleteDiscSymbol() {
        this.deleteDiscSymbol(1);
        this.deleteDiscSymbol(0);
    }

    private void deleteDiscSymbol(int type) {
        int id;
        org.eclipse.swt.widgets.List discList = this.discRemovedList;
        if (type == 0) {
            discList = this.discActiveList;
        }
        if ((id = discList.getSelectionIndex()) >= 0) {
            String symbol = discList.getItem(id);
            if (this.deletedDiscoveredSymbols == null) {
                this.deletedDiscoveredSymbols = new ArrayList();
            }
            this.deletedDiscoveredSymbols.add(symbol);
            ScannerConfigUtil.removeSymbolEntryValue((String)symbol, (Map)this.workingDiscoveredSymbols);
            int items = discList.getItemCount();
            discList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, type));
            if (items > 0) {
                if (id >= items) {
                    id = items - 1;
                }
                discList.setSelection(id);
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteAllDiscSymbols() {
        ScannerInfoCollector.getInstance().deleteAllSymbols(this.fProject);
        this.workingDiscoveredSymbols.clear();
        this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
        this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
        this.enableDiscoveredButtons();
        this.setDirty(true);
    }

    protected void enableDiscoveredButtons() {
        this.discoveredGroup.setEnabled(this.fProject != null);
        this.selectedLabel.setEnabled(this.fProject != null);
        this.discActiveList.setEnabled(this.fProject != null);
        this.removedLabel.setEnabled(this.fProject != null);
        this.discRemovedList.setEnabled(this.fProject != null);
        int activeItems = this.discActiveList.getItemCount();
        int activeSeclection = this.discActiveList.getSelectionIndex();
        int removedItems = this.discRemovedList.getItemCount();
        int removedSelection = this.discRemovedList.getSelectionIndex();
        if (activeItems > 0 && activeSeclection >= 0) {
            this.removeDiscSymbol.setEnabled(activeItems > 0 && activeSeclection >= 0);
            this.restoreDiscSymbol.setEnabled(removedItems > 0 && removedSelection >= 0);
        } else {
            this.restoreDiscSymbol.setEnabled(removedItems > 0 && removedSelection >= 0);
            this.removeDiscSymbol.setEnabled(activeItems > 0 && activeSeclection >= 0);
        }
        this.deleteDiscSymbol.setEnabled(activeItems > 0 && activeSeclection >= 0 || removedItems > 0 && removedSelection >= 0);
        this.deleteAllDiscSymbols.setEnabled(activeItems > 0 || removedItems > 0);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public String[] getManagedSymbols() {
        if (this.returnSymbols == null) {
            return new String[0];
        }
        return this.returnSymbols.toArray(new String[this.returnSymbols.size()]);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.discoveredSymbols = this.workingDiscoveredSymbols;
            this.returnSymbols = new ArrayList(this.discActiveList.getItemCount());
            this.returnSymbols.addAll(new ArrayList<String>(Arrays.asList(this.discActiveList.getItems())));
            this.fDirty = this.fWorkingDirty;
        } else if (1 == buttonId) {
            this.deletedDiscoveredSymbols = null;
            this.workingDiscoveredSymbols = null;
            this.setDirty(false);
        }
        super.buttonPressed(buttonId);
    }

    private void setDirty(boolean dirty) {
        this.fWorkingDirty = dirty;
    }

    public boolean saveTo(IDiscoveredPathManager.IDiscoveredPathInfo info) {
        if (this.fDirty || this.fProject == null && this.fContainer.getProject() != null) {
            info.setSymbolMap(this.discoveredSymbols);
            if (this.deletedDiscoveredSymbols != null) {
                Iterator i = this.deletedDiscoveredSymbols.iterator();
                while (i.hasNext()) {
                    ScannerInfoCollector.getInstance().deleteSymbol(this.fProject, (String)i.next());
                }
                this.deletedDiscoveredSymbols = null;
            }
        }
        this.setDirty(false);
        boolean rc = this.fDirty;
        this.fDirty = false;
        return rc;
    }

    public void restore() {
        if (this.fProject != null) {
            ScannerInfoCollector.getInstance().deleteAllSymbols(this.fProject);
        }
        this.discoveredSymbols = new LinkedHashMap();
        this.deletedDiscoveredSymbols = null;
        this.fDirty = true;
    }
}

