/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;

public class CExpression
extends CModificationVariable
implements IExpression {
    public CExpression(CDebugTarget target, ICDIExpression cdiExpression) {
        super(target, cdiExpression);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public CExpression(CDebugTarget target, ICDIVariableObject cdiVariableObject) {
        super(target, cdiVariableObject);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public String getExpressionText() {
        try {
            return this.getName();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public IValue getValue() {
        try {
            return super.getValue();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            ICDIExpression cdiExpression = this.getCDIExpression();
            if (cdiExpression != null) {
                this.getCDISession().getExpressionManager().destroyExpression(cdiExpression);
            }
        }
        catch (CDIException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    protected ICDIExpression getCDIExpression() throws CDIException {
        ICDIVariable var = this.getCDIVariable();
        return var instanceof ICDIExpression ? (ICDIExpression)var : null;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            if (event instanceof ICDIResumedEvent) {
                if (!(event.getSource() instanceof ICDITarget) || !this.getCDITarget().equals(event.getSource())) break;
                try {
                    this.setChanged(false);
                }
                catch (DebugException e) {
                    CDebugCorePlugin.log(e);
                }
                break;
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return false;
    }
}

