/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.model.AsmSourceLine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.ISourceLocator;

public class DisassemblyBlock
implements IDisassemblyBlock,
IAdaptable {
    private IDisassembly fDisassembly;
    private IAsmSourceLine[] fSourceLines;
    private long fStartAddress = 0L;
    private long fEndAddress = 0L;
    private boolean fMixedMode = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private DisassemblyBlock(IDisassembly disassembly) {
        this.fDisassembly = disassembly;
    }

    public static DisassemblyBlock create(IDisassembly disassembly, ICDIMixedInstruction[] instructions) {
        DisassemblyBlock block = new DisassemblyBlock(disassembly);
        block.setMixedMode(true);
        ISourceLocator adapter = disassembly.getDebugTarget().getLaunch().getSourceLocator();
        ICSourceLocator locator = null;
        if (adapter instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            locator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        }
        block.setSourceLines(DisassemblyBlock.createSourceLines(locator, instructions));
        block.initializeAddresses();
        return block;
    }

    public static DisassemblyBlock create(IDisassembly disassembly, ICDIInstruction[] instructions) {
        DisassemblyBlock block = new DisassemblyBlock(disassembly);
        block.setMixedMode(false);
        block.setSourceLines(DisassemblyBlock.createSourceLines(instructions));
        block.initializeAddresses();
        return block;
    }

    public IDisassembly getDisassembly() {
        return this.fDisassembly;
    }

    public String getModuleFile() {
        IDisassembly d = this.getDisassembly();
        if (d != null) {
            IExecFileInfo info;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((info = (IExecFileInfo)d.getAdapter(clazz)) != null && info.getExecFile() != null) {
                return info.getExecFile().getLocation().toOSString();
            }
        }
        return "";
    }

    public boolean contains(ICStackFrame frame) {
        if (!this.getDisassembly().getDebugTarget().equals(frame.getDebugTarget())) {
            return false;
        }
        long address = frame.getAddress();
        return address >= this.fStartAddress && address <= this.fEndAddress;
    }

    public IAsmSourceLine[] getSourceLines() {
        return this.fSourceLines;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean isMixedMode() {
        return this.fMixedMode;
    }

    public void dispose() {
    }

    private static IAsmSourceLine[] createSourceLines(ICSourceLocator locator, ICDIMixedInstruction[] mi) {
        IAsmSourceLine[] result = new IAsmSourceLine[mi.length];
        LineNumberReader reader = null;
        if (result.length > 0 && locator != null) {
            String fileName = mi[0].getFileName();
            Object element = locator.findSourceElement(fileName);
            File file = null;
            if (element instanceof IFile) {
                file = ((IFile)element).getLocation().toFile();
            } else if (element instanceof IStorage) {
                file = ((IStorage)element).getFullPath().toFile();
            }
            if (file != null) {
                try {
                    reader = new LineNumberReader(new FileReader(file));
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        int i = 0;
        while (i < result.length) {
            String text = null;
            if (reader != null) {
                int lineNumber = mi[i].getLineNumber();
                while (reader.getLineNumber() + 1 < lineNumber) {
                    try {
                        reader.readLine();
                    }
                    catch (IOException iOException) {}
                }
                if (reader.getLineNumber() + 1 == lineNumber) {
                    try {
                        text = String.valueOf(reader.readLine()) + '\n';
                    }
                    catch (IOException iOException) {}
                }
            }
            result[i] = new AsmSourceLine(text, mi[i].getInstructions());
            ++i;
        }
        return result;
    }

    private static IAsmSourceLine[] createSourceLines(ICDIInstruction[] instructions) {
        return new IAsmSourceLine[]{new AsmSourceLine("", instructions)};
    }

    private void initializeAddresses() {
        if (this.fSourceLines.length > 0) {
            IAsmInstruction[] instr = this.fSourceLines[0].getInstructions();
            this.fStartAddress = instr[0].getAdress();
            instr = this.fSourceLines[this.fSourceLines.length - 1].getInstructions();
            this.fEndAddress = instr[instr.length - 1].getAdress();
        }
    }

    private void setMixedMode(boolean mixedMode) {
        this.fMixedMode = mixedMode;
    }

    private void setSourceLines(IAsmSourceLine[] sourceLines) {
        this.fSourceLines = sourceLines;
    }
}

