/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTTypeId
implements IASTTypeId {
    private final boolean isTypename;
    private final boolean isUnsigned;
    private final boolean isSigned;
    private final boolean isShort;
    private final boolean isLong;
    private final boolean isVolatile;
    private final boolean isConst;
    private final String signature;
    private ITokenDuple tokenDuple;
    private final List arrayModifiers;
    private final String typeName;
    private final List pointerOps;
    private final IASTSimpleTypeSpecifier.Type kind;
    private List references = null;
    private ISymbol symbol;

    public ASTTypeId(IASTSimpleTypeSpecifier.Type kind, ITokenDuple duple, List pointerOps, List arrayMods, String signature, boolean isConst, boolean isVolatile, boolean isUnsigned, boolean isSigned, boolean isShort, boolean isLong, boolean isTypeName) {
        this.typeName = duple == null ? "" : duple.toString();
        this.tokenDuple = duple;
        this.kind = kind;
        this.pointerOps = pointerOps;
        this.arrayModifiers = arrayMods;
        this.signature = signature;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isUnsigned = isUnsigned;
        this.isSigned = isSigned;
        this.isShort = isShort;
        this.isLong = isLong;
        this.isTypename = isTypeName;
    }

    public IASTSimpleTypeSpecifier.Type getKind() {
        return this.kind;
    }

    public String getTypeOrClassName() {
        return this.typeName;
    }

    public Iterator getPointerOperators() {
        return this.pointerOps.iterator();
    }

    public Iterator getArrayModifiers() {
        return this.arrayModifiers.iterator();
    }

    public List getReferences() {
        return this.references == null ? Collections.EMPTY_LIST : this.references;
    }

    public ITokenDuple getTokenDuple() {
        return this.tokenDuple;
    }

    public String getFullSignature() {
        return this.signature;
    }

    public ISymbol getTypeSymbol() {
        return this.symbol;
    }

    public void setTypeSymbol(ISymbol symbol) {
        this.symbol = symbol;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
        if (this.tokenDuple != null) {
            this.tokenDuple.acceptElement(requestor, manager);
        }
        Iterator arrayMods = this.getArrayModifiers();
        while (arrayMods.hasNext()) {
            ((IASTArrayModifier)arrayMods.next()).acceptElement(requestor, manager);
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void addReferences(List list, ReferenceCache cache) {
        if (this.references == null) {
            this.references = new ArrayList(list.size());
        }
        int i = 0;
        while (i < list.size()) {
            this.references.add(list.get(i));
            ++i;
        }
    }

    public void freeReferences(IReferenceManager manager) {
        if (this.tokenDuple != null) {
            this.tokenDuple.freeReferences(manager);
        }
        if (this.references == null || this.references.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.references.size()) {
            manager.returnReference((IASTReference)this.references.get(i));
            ++i;
        }
        this.references.clear();
    }
}

