/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTScopedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTClassSpecifier
extends ASTScopedTypeSpecifier
implements IASTQClassSpecifier,
IASTQScope {
    private final String name;
    private List declarations = new ArrayList();
    private List baseClauses = new ArrayList();
    private List friends = new ArrayList();
    private ASTAccessVisibility access;
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;

    public ASTClassSpecifier(IASTScope scope, String name, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLineNumber, ASTAccessVisibility access) {
        super(scope, name);
        this.classNameType = type;
        this.classKind = kind;
        this.offsets.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.offsets.setNameOffset(nameOffset);
        this.offsets.setNameEndOffsetAndLineNumber(nameEndOffset, nameLineNumber);
        this.access = access;
        this.name = name;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return this.baseClauses.iterator();
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.access;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public String getName() {
        return this.name;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void addBaseClass(IASTBaseSpecifier baseSpecifier) {
        this.baseClauses.add(baseSpecifier);
    }

    public void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.access = visibility;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public Iterator getFriends() {
        return this.friends.iterator();
    }

    public void addFriendDeclaration(IASTDeclaration decl) {
        this.friends.add(decl);
    }
}

