/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.MultiLineTextFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildToolSettingsPage
extends BuildSettingsPage {
    private static final String ALL_OPTIONS = ManagedBuilderUIMessages.getResourceString("BuildToolSettingsPage.alloptions");
    private static final String COMMAND = "FieldEditors.tool.command";
    private static final String DEFAULT_SEPERATOR = ";";
    private static final String WHITESPACE = " ";
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private String allOptionsId = "";
    private Vector defaultOptionNames;
    private HashMap stringOptionsMap;
    private ITool tool;
    private HashMap userObjsMap;

    BuildToolSettingsPage(IConfiguration configuration, ITool tool) {
        super(configuration);
        this.tool = tool;
        this.allOptionsId = String.valueOf(tool.getId()) + ".allOptions";
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        StringFieldEditor stringField = new StringFieldEditor(this.tool.getId(), ManagedBuilderUIMessages.getResourceString(COMMAND), this.getFieldEditorParent());
        stringField.setEmptyStringAllowed(false);
        this.addField((FieldEditor)stringField);
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(this.allOptionsId, ALL_OPTIONS, this.getFieldEditorParent());
        this.getPreferenceStore().setValue(this.allOptionsId, "");
        this.addField(this.allOptionFieldEditor);
    }

    private String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(DEFAULT_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    private Vector getDefaultOptionNames() {
        if (this.defaultOptionNames == null) {
            this.defaultOptionNames = new Vector();
            this.defaultOptionNames.add("Other flags");
            this.defaultOptionNames.add("Linker flags");
            this.defaultOptionNames.add("Archiver flags");
            this.defaultOptionNames.add("Assembler flags");
        }
        return this.defaultOptionNames;
    }

    private Vector getOptionVector(String rawOptionString) {
        Vector<String> tokens = new Vector<String>(Arrays.asList(rawOptionString.split("\\s")));
        Vector<String> output = new Vector<String>(tokens.size());
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            int firstIndex = token.indexOf("\"");
            int lastIndex = token.lastIndexOf("\"");
            if (firstIndex != -1 && firstIndex == lastIndex) {
                while (iter.hasNext()) {
                    String nextToken = iter.next();
                    token = String.valueOf(token) + WHITESPACE + nextToken;
                    if (nextToken.indexOf("\"") != -1) break;
                }
            }
            output.add(token);
        }
        return output;
    }

    private String getToolFlags() throws BuildException {
        ITool[] tools = this.configuration.getTools();
        int i = 0;
        while (i < tools.length) {
            if (tools[i] instanceof ToolReference) {
                if (((ToolReference)tools[i]).references(this.tool)) {
                    this.tool = tools[i];
                    break;
                }
            } else if (tools[i].equals(this.tool)) break;
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        IOption[] options = this.tool.getOptions();
        String listStr = "";
        String[] listVal = null;
        int k = 0;
        while (k < options.length) {
            IOption option = options[k];
            switch (option.getValueType()) {
                case 0: {
                    if (!this.getPreferenceStore().getBoolean(option.getId())) break;
                    buf.append(String.valueOf(option.getCommand()) + WHITESPACE);
                    break;
                }
                case 1: {
                    String string;
                    String enumCommand = this.getPreferenceStore().getString(option.getId());
                    if (enumCommand.indexOf(DEFAULT_SEPERATOR) != -1) {
                        enumCommand = option.getSelectedEnum();
                    }
                    if ((string = option.getEnumCommand(enumCommand)).length() <= 0) break;
                    buf.append(String.valueOf(string) + WHITESPACE);
                    break;
                }
                case 2: {
                    String val = this.getPreferenceStore().getString(option.getId());
                    this.stringOptionsMap.put(option, val);
                    if (val.length() <= 0) break;
                    buf.append(String.valueOf(val) + WHITESPACE);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String cmd = option.getCommand();
                    listStr = this.getPreferenceStore().getString(option.getId());
                    if (cmd == null) {
                        this.userObjsMap.put(option, listStr);
                    }
                    listVal = BuildToolsSettingsStore.parseString(listStr);
                    int j = 0;
                    while (j < listVal.length) {
                        String temp = listVal[j];
                        if (cmd != null) {
                            buf.append(String.valueOf(cmd) + temp + WHITESPACE);
                        } else {
                            buf.append(String.valueOf(temp) + WHITESPACE);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++k;
        }
        return buf.toString().trim();
    }

    public boolean isForTool(ITool tool) {
        if (tool != null) {
            return tool.equals(this.tool);
        }
        return false;
    }

    public void parseAllOptions() {
        IOption opt;
        ITool[] tools = this.configuration.getTools();
        int i = 0;
        while (i < tools.length) {
            if (tools[i] instanceof ToolReference) {
                if (((ToolReference)tools[i]).references(this.tool)) {
                    this.tool = tools[i];
                    break;
                }
            } else if (tools[i].equals(this.tool)) break;
            ++i;
        }
        String alloptions = this.getPreferenceStore().getString(this.allOptionsId);
        ArrayList<String> optionsList = new ArrayList<String>();
        StringBuffer addnOptions = new StringBuffer();
        Vector optionsArr = this.getOptionVector(alloptions);
        Iterator optIter = optionsArr.iterator();
        while (optIter.hasNext()) {
            String optionValue = (String)optIter.next();
            boolean optionValueExist = false;
            IOption[] options = this.tool.getOptions();
            int k = 0;
            while (k < options.length) {
                opt = options[k];
                opt.getId();
                Iterator stringOptsIter = this.stringOptionsMap.values().iterator();
                while (stringOptsIter.hasNext()) {
                    if (((String)stringOptsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                Iterator userObjsIter = this.userObjsMap.values().iterator();
                while (userObjsIter.hasNext()) {
                    if (((String)userObjsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                if (!optionValueExist) {
                    switch (opt.getValueType()) {
                        case 0: {
                            if (!opt.getCommand().equals(optionValue)) break;
                            this.getPreferenceStore().setValue(opt.getId(), true);
                            optionValueExist = true;
                            break;
                        }
                        case 1: {
                            String string = "";
                            String[] enumValues = opt.getApplicableValues();
                            int i2 = 0;
                            while (i2 < enumValues.length) {
                                if (opt.getEnumCommand(enumValues[i2]).equals(optionValue)) {
                                    string = enumValues[i2];
                                    optionValueExist = true;
                                }
                                ++i2;
                            }
                            if (string.equals("")) break;
                            this.getPreferenceStore().setValue(opt.getId(), string);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (opt.getCommand() == null || !optionValue.startsWith(opt.getCommand())) break;
                            optionsList.add(optionValue);
                            optionValueExist = true;
                            break;
                        }
                    }
                }
                ++k;
            }
            if (optionValueExist) continue;
            addnOptions.append(String.valueOf(optionValue) + WHITESPACE);
        }
        Set set = this.stringOptionsMap.keySet();
        int s = 0;
        while (s < set.size()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.stringOptionsMap.get(key);
                if (alloptions.indexOf(val) != -1) continue;
                StringBuffer buf = new StringBuffer();
                String[] vals = val.split(WHITESPACE);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        buf.append(String.valueOf(vals[t]) + WHITESPACE);
                    }
                    ++t;
                }
                this.getPreferenceStore().setValue(((IOption)key).getId(), buf.toString().trim());
            }
            ++s;
        }
        Set objSet = this.userObjsMap.keySet();
        int s2 = 0;
        while (s2 < objSet.size()) {
            Iterator iterator = objSet.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.userObjsMap.get(key);
                ArrayList<String> list = new ArrayList<String>();
                String[] vals = BuildToolsSettingsStore.parseString(val);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        list.add(vals[t]);
                    }
                    ++t;
                }
                String[] listArr = new String[list.size()];
                list.toArray(listArr);
                String liststr = BuildToolsSettingsStore.createList(listArr);
                this.getPreferenceStore().setValue(((IOption)key).getId(), liststr);
            }
            ++s2;
        }
        IOption[] options = this.tool.getOptions();
        int k = 0;
        while (k < options.length) {
            opt = options[k];
            opt.getId();
            switch (opt.getValueType()) {
                case 0: {
                    ArrayList optsList = new ArrayList(optionsArr);
                    if (opt.getCommand() == null || optsList.contains(opt.getCommand())) break;
                    this.getPreferenceStore().setValue(opt.getId(), false);
                    break;
                }
                case 2: {
                    if (!this.getDefaultOptionNames().contains(opt.getName())) break;
                    String newOptions = this.getPreferenceStore().getString(opt.getId());
                    if (addnOptions.length() > 0) {
                        newOptions = String.valueOf(newOptions) + WHITESPACE + addnOptions.toString().trim();
                    }
                    this.getPreferenceStore().setValue(opt.getId(), newOptions);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ArrayList<String> newList = new ArrayList<String>();
                    int i3 = 0;
                    while (i3 < optionsList.size()) {
                        if (opt.getCommand() != null && ((String)optionsList.get(i3)).startsWith(opt.getCommand())) {
                            newList.add(((String)optionsList.get(i3)).substring(opt.getCommand().length()));
                        }
                        ++i3;
                    }
                    String[] strlist = new String[newList.size()];
                    newList.toArray(strlist);
                    newList.clear();
                    this.getPreferenceStore().setValue(opt.getId(), BuildToolsSettingsStore.createList(strlist));
                    break;
                }
            }
            ++k;
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.parseAllOptions();
        ITool[] tools = this.configuration.getTools();
        int i = 0;
        while (i < tools.length) {
            if (tools[i] instanceof ToolReference) {
                if (((ToolReference)tools[i]).references(this.tool)) {
                    this.tool = tools[i];
                    break;
                }
            } else if (tools[i].equals(this.tool)) break;
            ++i;
        }
        IOption[] options = this.tool.getOptions();
        int i2 = 0;
        while (i2 < options.length) {
            IOption option = options[i2];
            switch (option.getValueType()) {
                case 0: {
                    boolean boolVal = this.getPreferenceStore().getBoolean(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (boolean)boolVal);
                    break;
                }
                case 1: {
                    String enumVal = this.getPreferenceStore().getString(option.getId());
                    String enumId = option.getEnumeratedId(enumVal);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                    break;
                }
                case 2: {
                    String strVal = this.getPreferenceStore().getString(option.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String)strVal);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String listStr = this.getPreferenceStore().getString(option.getId());
                    String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)option, (String[])listVal);
                    break;
                }
            }
            ++i2;
        }
        String command = this.getPreferenceStore().getString(this.tool.getId());
        if (command.length() == 0) {
            return result;
        }
        ManagedBuildManager.setToolCommand((IConfiguration)this.configuration, (ITool)this.tool, (String)command);
        return result;
    }

    public void storeSettings() {
        super.performOk();
    }

    public void updateAllOptionField() {
        try {
            if (this.getToolFlags() != null) {
                this.getPreferenceStore().setValue(this.allOptionsId, this.getToolFlags());
                this.allOptionFieldEditor.load();
            }
        }
        catch (BuildException buildException) {}
    }
}

