/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class CExtensionReference
implements ICExtensionReference {
    private CDescriptor fDescriptor;
    private String fExtPoint;
    private String fId;

    public CExtensionReference(CDescriptor descriptor, String extPoint, String id) {
        this.fDescriptor = descriptor;
        this.fExtPoint = extPoint;
        this.fId = id;
    }

    public String getExtension() {
        return this.fExtPoint;
    }

    public String getID() {
        return this.fId;
    }

    private CExtensionInfo getInfo() {
        return this.fDescriptor.getInfo(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CExtensionReference) {
            CExtensionReference ext = (CExtensionReference)obj;
            if (ext.fExtPoint.equals(this.fExtPoint) && ext.fId.equals(this.fId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fExtPoint.hashCode() + this.fId.hashCode();
    }

    public void setExtensionData(String key, String value) throws CoreException {
        this.getInfo().setAttribute(key, value);
        this.fDescriptor.updateOnDisk();
        if (!this.fDescriptor.isInitializing) {
            this.fDescriptor.fManager.fireEvent(new CDescriptorEvent(this.fDescriptor, 1, 0));
        }
    }

    public String getExtensionData(String key) {
        return this.getInfo().getAttribute(key);
    }

    public ICExtension createExtension() throws CoreException {
        return this.fDescriptor.createExtensions(this);
    }

    public IConfigurationElement[] getExtensionElements() throws CoreException {
        return this.fDescriptor.getConfigurationElement(this);
    }
}

