/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.DestroyWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.ReconcileWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.WorkingCopyInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkingCopy
extends TranslationUnit
implements IWorkingCopy {
    protected IBufferFactory bufferFactory;
    protected int useCount = 1;

    public WorkingCopy(ICElement parent, IFile file, IBufferFactory bufferFactory) {
        this(parent, file, bufferFactory, null);
    }

    public WorkingCopy(ICElement parent, IFile file, IBufferFactory bufferFactory, IProblemRequestor requestor) {
        super(parent, file);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
        this.problemRequestor = requestor;
    }

    public WorkingCopy(ICElement parent, IPath path, IBufferFactory bufferFactory) {
        super(parent, path);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
    }

    public void commit(boolean force, IProgressMonitor monitor) throws CModelException {
        ITranslationUnit original = this.getOriginalElement();
        if (original.exists()) {
            CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
            this.runOperation(op, monitor);
        } else {
            String contents = this.getSource();
            if (contents == null) {
                return;
            }
            try {
                IFile originalRes = (IFile)original.getResource();
                String encoding = null;
                try {
                    encoding = originalRes.getCharset();
                }
                catch (CoreException coreException) {}
                byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                if (originalRes.exists()) {
                    originalRes.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    originalRes.create((InputStream)stream, force, monitor);
                }
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
        }
    }

    protected CElementInfo createElementInfo() {
        return new WorkingCopyInfo(this);
    }

    public void destroy() {
        if (--this.useCount > 0) {
            return;
        }
        try {
            DestroyWorkingCopyOperation op = new DestroyWorkingCopyOperation(this);
            this.runOperation(op, null);
        }
        catch (CModelException cModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public ITranslationUnit getOriginalElement() {
        return new TranslationUnit(this.getParent(), this.getFile());
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this;
    }

    public IWorkingCopy getWorkingCopy() {
        return this;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) {
        return this;
    }

    public boolean isBasedOn(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        try {
            return ((TranslationUnitInfo)this.getElementInfo()).fTimestamp == ((IFile)resource).getModificationStamp();
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void open(IProgressMonitor monitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(monitor);
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBuffer originalBuffer;
            block8: {
                ITranslationUnit original = this.getOriginalElement();
                originalBuffer = null;
                try {
                    originalBuffer = original.getBuffer();
                }
                catch (CModelException e) {
                    if (e.getCModelStatus().doesNotExist()) break block8;
                    throw e;
                }
            }
            if (originalBuffer != null) {
                char[] originalContents = originalBuffer.getCharacters();
                if (originalContents != null) {
                    buffer.setContents((char[])originalContents.clone());
                }
            } else {
                buffer.setContents(new char[0]);
            }
        }
        this.getBufferManager().addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public IMarker[] reconcile() throws CModelException {
        this.reconcile(false, null);
        return null;
    }

    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection);
        this.runOperation(op, monitor);
    }

    public void restore() throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        TranslationUnit original = (TranslationUnit)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    public void save(IProgressMonitor pm, boolean force) throws CModelException {
        if (this.isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void updateTimeStamp(TranslationUnit original) throws CModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new CModelException(new CModelStatus(995));
        }
        ((TranslationUnitInfo)this.getElementInfo()).fTimestamp = timeStamp;
    }
}

