/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class CygPath {
    private Process cygpath;
    private BufferedReader stdout;
    private BufferedWriter stdin;

    public CygPath(String command) throws IOException {
        String[] args = new String[]{command, "--windows", "--file", "-"};
        this.cygpath = ProcessFactory.getFactory().exec(args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.cygpath.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.cygpath.getInputStream()));
    }

    public CygPath() throws IOException {
        this("cygpath");
    }

    public String getFileName(String name) throws IOException {
        this.stdin.write(String.valueOf(name) + "\n");
        this.stdin.flush();
        String str = this.stdout.readLine();
        if (str != null) {
            return str.trim();
        }
        throw new IOException();
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.cygpath.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.cygpath.destroy();
    }
}

