/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.xcoff.XCoff32;

public class AR {
    protected String filename;
    protected RandomAccessFile file;
    private ARHeader header;
    private MemberHeader[] memberHeaders;

    public AR(String filename) throws IOException {
        this.filename = filename;
        this.file = new RandomAccessFile(filename, "r");
        this.header = new ARHeader();
        if (!this.header.isXcoffARHeader()) {
            this.file.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    public void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] ident) {
        return ident.length >= 8 && ident[0] == 60 && ident[1] == 98 && ident[2] == 105 && ident[3] == 103 && ident[4] == 97 && ident[5] == 102 && ident[6] == 62 && ident[7] == 10;
    }

    private void loadHeaders() throws IOException {
        if (this.memberHeaders != null) {
            return;
        }
        Vector<MemberHeader> v = new Vector<MemberHeader>();
        try {
            long pos = this.header.fstmoff;
            while (pos < this.file.length()) {
                this.file.seek(pos);
                MemberHeader aHeader = new MemberHeader();
                aHeader.getObjectName();
                v.add(aHeader);
                if (pos != 0L && pos != this.header.lstmoff) {
                    pos = aHeader.nxtmem;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        this.memberHeaders = v.toArray(new MemberHeader[0]);
    }

    public MemberHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.memberHeaders;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        int i = 0;
        while (i < this.memberHeaders.length) {
            String object_name = this.memberHeaders[i].getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = this.memberHeaders[i].getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++i;
        }
        return names_used.toArray(new String[0]);
    }

    private boolean stringInStrings(String str, String[] set) {
        int i = 0;
        while (i < set.length) {
            if (str.compareTo(set[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String removeBlanks(String str) {
        while (str.charAt(str.length() - 1) == ' ') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    private RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.file == null) {
            this.file = new RandomAccessFile(this.filename, "r");
        }
        return this.file;
    }

    public static void main(String[] args) {
        try {
            AR ar = new AR(args[0]);
            ar.getHeaders();
            ar.extractFiles(args[0]);
            System.out.println(ar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ARHeader {
        private static final int SAIAMAG = 8;
        private byte[] fl_magic = new byte[8];
        private byte[] fl_memoff = new byte[20];
        private byte[] fl_gstoff = new byte[20];
        private byte[] fl_gst64off = new byte[20];
        private byte[] fl_fstmoff = new byte[20];
        private byte[] fl_lstmoff = new byte[20];
        private byte[] fl_freeoff = new byte[20];
        private long fstmoff = 0L;
        private long lstmoff = 0L;
        private long memoff = 0L;

        public ARHeader() throws IOException {
            try {
                AR.this.getRandomAccessFile();
                AR.this.file.seek(0L);
                AR.this.file.read(this.fl_magic);
                if (AR.isARHeader(this.fl_magic)) {
                    AR.this.file.read(this.fl_memoff);
                    AR.this.file.read(this.fl_gstoff);
                    AR.this.file.read(this.fl_gst64off);
                    AR.this.file.read(this.fl_fstmoff);
                    AR.this.file.read(this.fl_lstmoff);
                    AR.this.file.read(this.fl_freeoff);
                    this.fstmoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_fstmoff)));
                    this.lstmoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_lstmoff)));
                    this.memoff = Long.parseLong(AR.this.removeBlanks(new String(this.fl_memoff)));
                }
            }
            catch (IOException e) {
                AR.this.dispose();
                CCorePlugin.log(e);
            }
        }

        public boolean isXcoffARHeader() {
            return this.fstmoff != 0L;
        }
    }

    public class MemberHeader {
        byte[] ar_size = new byte[20];
        byte[] ar_nxtmem = new byte[20];
        byte[] ar_prvmem = new byte[20];
        byte[] ar_date = new byte[12];
        byte[] ar_uid = new byte[12];
        byte[] ar_gid = new byte[12];
        byte[] ar_mode = new byte[12];
        byte[] ar_namlen = new byte[4];
        byte[] ar_name;
        byte[] ar_fmag = new byte[2];
        long size;
        long nxtmem;
        long prvmem;
        int namlen;
        String name;
        long file_offset;

        private String removeBlanks(String str) {
            while (str.charAt(str.length() - 1) == ' ') {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        public MemberHeader() throws IOException {
            AR.this.file.read(this.ar_size);
            AR.this.file.read(this.ar_nxtmem);
            AR.this.file.read(this.ar_prvmem);
            AR.this.file.read(this.ar_date);
            AR.this.file.read(this.ar_uid);
            AR.this.file.read(this.ar_gid);
            AR.this.file.read(this.ar_mode);
            AR.this.file.read(this.ar_namlen);
            this.namlen = Integer.parseInt(this.removeBlanks(new String(this.ar_namlen)));
            this.ar_name = new byte[this.namlen];
            AR.this.file.read(this.ar_name);
            AR.this.file.read(this.ar_fmag);
            this.size = Long.parseLong(this.removeBlanks(new String(this.ar_size)));
            this.nxtmem = Long.parseLong(this.removeBlanks(new String(this.ar_nxtmem)));
            this.prvmem = Long.parseLong(this.removeBlanks(new String(this.ar_prvmem)));
            this.name = new String(this.ar_name, 0, this.namlen);
            this.file_offset = AR.this.file.getFilePointer();
            if (this.file_offset % 2L == 1L) {
                ++this.file_offset;
            }
        }

        public String getObjectName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public XCoff32 getXCoff() throws IOException {
            return new XCoff32(AR.this.filename, this.file_offset);
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            AR.this.file = AR.this.getRandomAccessFile();
            AR.this.file.seek(this.file_offset);
            AR.this.file.read(temp);
            AR.this.dispose();
            return temp;
        }
    }
}

