/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.FindAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class FindDeclarationsInWorkingSetAction
extends FindAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        this(site, CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.tooltip"));
    }

    public FindDeclarationsInWorkingSetAction(CEditor editor) {
        this(editor, CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.tooltip"));
    }

    public FindDeclarationsInWorkingSetAction(CEditor editor, String label, String tooltip) {
        super(editor);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, String label, String tooltip) {
        super(site);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    protected String getScopeDescription() {
        return CSearchMessages.getFormattedString("WorkingSetScope", CSearchUtil.toString(this.fWorkingSet));
    }

    protected ICSearchScope getScope() {
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null) {
            workingSets = CSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets == null) {
                return null;
            }
            this.fWorkingSet = workingSets;
        }
        ICSearchScope scope = CSearchScopeFactory.getInstance().createCSearchScope(workingSets);
        CSearchUtil.updateLRUWorkingSets(workingSets);
        return scope;
    }

    protected ICSearchConstants.LimitTo getLimitTo() {
        return ICSearchConstants.DECLARATIONS;
    }
}

