/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CApplicationLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IBinary bin, String mode) {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
            if (config != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                config.launch(mode, null);
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.errorDialog("Launch failed", e.getStatus());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getCLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String programName = AbstractCLaunchDelegate.getProgramName(config);
                String projectName = AbstractCLaunchDelegate.getProjectName(config);
                String name = bin.getResource().getProjectRelativePath().toString();
                if (programName != null && programName.equals(name) && projectName != null && projectName.equals(bin.getCProject().getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            String programCPU = bin.getCPU();
            ICDebugConfiguration debugConfig = null;
            ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
            ArrayList<ICDebugConfiguration> debugList = new ArrayList<ICDebugConfiguration>(debugConfigs.length);
            String os = Platform.getOS();
            int i = 0;
            while (i < debugConfigs.length) {
                String platform = debugConfigs[i].getPlatform();
                if (debugConfigs[i].supportsMode("run") && (platform.equals("*") || platform.equals(os)) && debugConfigs[i].supportsCPU(programCPU)) {
                    debugList.add(debugConfigs[i]);
                }
                ++i;
            }
            debugConfigs = debugList.toArray(new ICDebugConfiguration[0]);
            if (debugConfigs.length == 1) {
                debugConfig = debugConfigs[0];
            } else if (debugConfigs.length > 1) {
                debugConfig = this.chooseDebugConfig(debugConfigs, mode);
            }
            if (debugConfig != null) {
                configuration = this.createConfiguration(bin, debugConfig);
            }
        } else {
            configuration = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode);
        }
        return configuration;
    }

    private ILaunchConfiguration createConfiguration(IBinary bin, ICDebugConfiguration debugConfig) {
        ILaunchConfiguration config = null;
        try {
            String projectName = bin.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(bin.getElementName()));
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", debugConfig.getID());
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log((Throwable)ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.localCLaunch");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private ICDebugConfiguration chooseDebugConfig(ICDebugConfiguration[] debugConfigs, String mode) {
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ICDebugConfiguration) {
                    return ((ICDebugConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)provider);
        dialog.setElements((Object[])debugConfigs);
        dialog.setTitle(this.getDebugConfigDialogTitleString(debugConfigs, mode));
        dialog.setMessage(this.getDebugConfigDialogMessageString(debugConfigs, mode));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        provider.dispose();
        if (result == 0) {
            return (ICDebugConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected String getDebugConfigDialogTitleString(ICDebugConfiguration[] configList, String mode) {
        return "Launch Debug Configuration Selection";
    }

    protected String getDebugConfigDialogMessageString(ICDebugConfiguration[] configList, String mode) {
        if (mode.equals("debug")) {
            return "Choose a debug configuration to debug";
        }
        return "Choose a configuration to run";
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getLaunchSelectionDialogTitleString(configList, mode));
        dialog.setMessage(this.getLaunchSelectionDialogMessageString(configList, mode));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected String getLaunchSelectionDialogTitleString(List configList, String mode) {
        return "Launch Configuration Selection";
    }

    protected String getLaunchSelectionDialogMessageString(List binList, String mode) {
        if (mode.equals("debug")) {
            return "Choose a launch configuration to debug";
        }
        return "Choose a launch configuration to run";
    }

    protected IBinary chooseBinary(List binList, String mode) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements(binList.toArray());
        dialog.setTitle(this.getBinarySelectionDialogTitleString(binList, mode));
        dialog.setMessage(this.getBinarySelectionDialogMessageString(binList, mode));
        dialog.setUpperListLabel(LaunchUIPlugin.getResourceString("Launch.common.BinariesColon"));
        dialog.setLowerListLabel(LaunchUIPlugin.getResourceString("Launch.common.QualifierColon"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    protected String getBinarySelectionDialogTitleString(List binList, String mode) {
        return "C Local Application";
    }

    protected String getBinarySelectionDialogMessageString(List binList, String mode) {
        if (mode.equals("debug")) {
            return "Choose a local application to debug";
        }
        return "Choose a local application to run";
    }

    private void searchAndLaunch(final Object[] elements, String mode) {
        if (elements != null && elements.length > 0) {
            IBinary bin = null;
            if (elements.length == 1 && elements[0] instanceof IBinary) {
                bin = (IBinary)elements[0];
            } else {
                final ArrayList results = new ArrayList();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor pm) throws InterruptedException {
                        int nElements = elements.length;
                        pm.beginTask("Looking for executables", nElements);
                        try {
                            SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                            int i = 0;
                            while (i < nElements) {
                                if (elements[i] instanceof IAdaptable) {
                                    ICProject cproject;
                                    IResource r;
                                    IAdaptable iAdaptable = (IAdaptable)elements[i];
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if ((r = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                                        try {
                                            IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                                            int j = 0;
                                            while (j < bins.length) {
                                                if (bins[j].isExecutable()) {
                                                    results.add(bins[j]);
                                                }
                                                ++j;
                                            }
                                        }
                                        catch (CModelException cModelException) {}
                                    }
                                }
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                sub.done();
                                ++i;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            pm.done();
                            throw throwable;
                        }
                        {
                            Object var9_11 = null;
                        }
                        pm.done();
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)e.getMessage());
                    return;
                }
                int count = results.size();
                if (count == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Launch_failed_no_binaries"));
                } else {
                    bin = count > 1 ? this.chooseBinary(results, mode) : (IBinary)results.get(0);
                }
            }
            if (bin != null) {
                this.launch(bin, mode);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Launch_failed_no_project_selected"));
        }
    }
}

