/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class LocalCLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Launching_Local_C_Application"), -1);
        if (monitor.isCanceled()) {
            return;
        }
        IFile exeFile = this.getProgramFile(config);
        String[] arguments = this.getProgramArgumentsArray(config);
        ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
        command.add(exeFile.getLocation().toOSString());
        command.addAll(Arrays.asList(arguments));
        String[] commandArray = command.toArray(new String[command.size()]);
        this.setSourceLocator(launch, config);
        if (mode.equals("debug")) {
            IProcess debuggerProcess = null;
            ICDebugConfiguration debugConfig = this.getDebugConfig(config);
            ICDISession dsession = null;
            try {
                String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (debugMode.equals("run")) {
                    dsession = debugConfig.getDebugger().createLaunchSession(config, exeFile);
                    ICDIRuntimeOptions opt = dsession.getRuntimeOptions();
                    opt.setArguments(this.getProgramArgumentsArray(config));
                    File wd = this.getWorkingDirectory(config);
                    if (wd != null) {
                        opt.setWorkingDirectory(wd.getAbsolutePath());
                    }
                    opt.setEnvironment(this.expandEnvironment(config));
                    ICDITarget dtarget = dsession.getTargets()[0];
                    Process process = dtarget.getProcess();
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
                    Process debugger = dsession.getSessionProcess();
                    if (debugger != null) {
                        debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)this.renderDebuggerProcessLabel());
                    }
                    boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                    CDebugModel.newDebugTarget((ILaunch)launch, (ICDITarget)dsession.getCurrentTarget(), (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IProcess)debuggerProcess, (IFile)exeFile, (boolean)true, (boolean)false, (boolean)stopInMain);
                } else if (debugMode.equals("attach")) {
                    Process debugger;
                    int pid = this.getProcessID();
                    if (pid == -1) {
                        this.cancel(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.No_Process_ID_selected"), 107);
                    }
                    if ((debugger = (dsession = debugConfig.getDebugger().createAttachSession(config, exeFile, pid)).getSessionProcess()) != null) {
                        debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)this.renderDebuggerProcessLabel());
                        launch.removeProcess(debuggerProcess);
                    }
                    CDebugModel.newAttachDebugTarget((ILaunch)launch, (ICDITarget)dsession.getCurrentTarget(), (String)this.renderTargetLabel(debugConfig), (IProcess)debuggerProcess, (IFile)exeFile);
                }
            }
            catch (CDIException e) {
                if (dsession != null) {
                    try {
                        dsession.terminate();
                    }
                    catch (CDIException cDIException) {}
                }
                this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Failed_Launching_CDI_Debugger"), e, 150);
            }
        } else {
            File wd = this.getWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            Process process = this.exec(commandArray, this.getEnvironmentProperty(config), wd);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
        }
        monitor.done();
    }

    private int getProcessID() throws CoreException {
        final Shell shell = LaunchUIPlugin.getShell();
        final int[] pid = new int[]{-1};
        if (shell == null) {
            this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.No_Shell_available_in_Launch"), null, 150);
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IProcessInfo info;
                LabelProvider provider = new LabelProvider(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getText(Object element) {
                        IProcessInfo info = (IProcessInfo)element;
                        Path path = new Path(info.getName());
                        return String.valueOf(path.lastSegment()) + " - " + info.getPid();
                    }

                    public Image getImage(Object element) {
                        return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                    }
                };
                LabelProvider qprovider = new LabelProvider(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getText(Object element) {
                        IProcessInfo info = (IProcessInfo)element;
                        return info.getName();
                    }

                    public Image getImage(Object element) {
                        return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                    }
                };
                TwoPaneElementSelector dialog = new TwoPaneElementSelector(shell, (ILabelProvider)provider, (ILabelProvider)qprovider);
                dialog.setTitle(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Select_Process"));
                dialog.setMessage(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Select_Process_to_attach_debugger_to"));
                IProcessList plist = null;
                try {
                    plist = CCorePlugin.getDefault().getProcessList();
                }
                catch (CoreException e) {
                    LaunchUIPlugin.errorDialog(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.CDT_Launch_Error"), e.getStatus());
                }
                if (plist == null) {
                    MessageDialog.openError((Shell)shell, (String)LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.CDT_Launch_Error"), (String)LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Platform_cannot_list_processes"));
                    return;
                }
                dialog.setElements((Object[])plist.getProcessList());
                if (dialog.open() == 0 && (info = (IProcessInfo)dialog.getFirstResult()) != null) {
                    pid[0] = info.getPid();
                }
            }
        });
        return pid[0];
    }

    protected Process exec(String[] cmdLine, Properties environ, File workingDirectory) throws CoreException {
        Process p;
        block6: {
            p = null;
            Properties props = this.getDefaultEnvironment();
            props.putAll((Map<?, ?>)this.expandEnvironment(environ));
            String[] envp = null;
            ArrayList<String> envList = new ArrayList<String>();
            Enumeration<?> names = props.propertyNames();
            if (names != null) {
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                }
                envp = envList.toArray(new String[envList.size()]);
            }
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, envp) : ProcessFactory.getFactory().exec(cmdLine, envp, workingDirectory);
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Error_starting_process"), e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Does_not_support_working_dir"), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block6;
                p = this.exec(cmdLine, environ, null);
            }
        }
        return p;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

