/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.core.runtime.IStatus;

public class QualifiedTypeName
implements IQualifiedTypeName {
    private String[] fSegments;
    private int fHashCode;

    public QualifiedTypeName(IQualifiedTypeName typeName) {
        this(typeName.segments());
    }

    public QualifiedTypeName(String[] names) {
        this.fSegments = new String[names.length];
        System.arraycopy(names, 0, this.fSegments, 0, names.length);
    }

    public QualifiedTypeName(String name, String[] enclosingNames) {
        if (enclosingNames != null) {
            this.fSegments = new String[enclosingNames.length + 1];
            System.arraycopy(enclosingNames, 0, this.fSegments, 0, enclosingNames.length);
            this.fSegments[this.fSegments.length - 1] = name;
        } else {
            this.fSegments = new String[]{name};
        }
    }

    public QualifiedTypeName(String qualifiedName) {
        int qualifierIndex = qualifiedName.indexOf("::", 0);
        if (qualifierIndex == -1) {
            this.fSegments = new String[]{qualifiedName};
        } else {
            String nextName;
            ArrayList<String> namesList = new ArrayList<String>(5);
            int lastIndex = 0;
            while (qualifierIndex >= 0) {
                nextName = qualifiedName.substring(lastIndex, qualifierIndex);
                lastIndex = qualifierIndex + "::".length();
                namesList.add(nextName);
                qualifierIndex = qualifiedName.indexOf("::", lastIndex);
            }
            nextName = qualifiedName.substring(lastIndex);
            namesList.add(nextName);
            this.fSegments = namesList.toArray(new String[namesList.size()]);
        }
    }

    public String getName() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return null;
    }

    public String[] getEnclosingNames() {
        if (this.fSegments.length > 1) {
            String[] enclosingNames = new String[this.fSegments.length - 1];
            System.arraycopy(this.fSegments, 0, enclosingNames, 0, this.fSegments.length - 1);
            return enclosingNames;
        }
        return null;
    }

    public String getFullyQualifiedName() {
        if (this.fSegments.length > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fSegments.length) {
                if (i > 0) {
                    buf.append("::");
                }
                buf.append(this.fSegments[i]);
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public IQualifiedTypeName getEnclosingTypeName() {
        String[] enclosingNames = this.getEnclosingNames();
        if (enclosingNames != null) {
            return new QualifiedTypeName(enclosingNames);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.fSegments.length == 0;
    }

    public boolean isGlobal() {
        if (this.fSegments.length <= 1) {
            return true;
        }
        return this.fSegments[0] == null || this.fSegments[0].length() == 0;
    }

    public int segmentCount() {
        return this.fSegments.length;
    }

    public String[] segments() {
        return this.fSegments;
    }

    public String segment(int index) {
        if (index >= this.fSegments.length) {
            return null;
        }
        return this.fSegments[index];
    }

    public String lastSegment() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return null;
    }

    public int matchingFirstSegments(IQualifiedTypeName typeName) {
        int max = Math.min(this.fSegments.length, typeName.segmentCount());
        int count = 0;
        int i = 0;
        while (i < max) {
            if (!this.fSegments[i].equals(typeName.segment(i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public boolean isPrefixOf(IQualifiedTypeName typeName) {
        if (this.isEmpty()) {
            return true;
        }
        if (this.fSegments.length > typeName.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            if (!this.fSegments[i].equals(typeName.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IQualifiedTypeName append(String[] names) {
        String[] newNames = new String[this.fSegments.length + names.length];
        System.arraycopy(this.fSegments, 0, newNames, 0, this.fSegments.length);
        System.arraycopy(names, 0, newNames, this.fSegments.length, names.length);
        return new QualifiedTypeName(newNames);
    }

    public IQualifiedTypeName append(IQualifiedTypeName typeName) {
        return this.append(typeName.segments());
    }

    public IQualifiedTypeName append(String qualifiedName) {
        return this.append(new QualifiedTypeName(qualifiedName));
    }

    public IQualifiedTypeName removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.fSegments.length || count < 0) {
            return new QualifiedTypeName(new String[0]);
        }
        int newSize = this.fSegments.length - count;
        String[] newNames = new String[newSize];
        System.arraycopy(this.fSegments, count, newNames, 0, newSize);
        return new QualifiedTypeName(newNames);
    }

    public IQualifiedTypeName removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.fSegments.length || count < 0) {
            return new QualifiedTypeName(new String[0]);
        }
        int newSize = this.fSegments.length - count;
        String[] newNames = new String[newSize];
        System.arraycopy(this.fSegments, 0, newNames, 0, newSize);
        return new QualifiedTypeName(newNames);
    }

    public boolean isLowLevel() {
        int i = 0;
        while (i < this.fSegments.length) {
            if (this.fSegments[i].startsWith("_")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean validate() {
        int i = 0;
        while (i < this.fSegments.length) {
            if (!QualifiedTypeName.isValidSegment(this.fSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidSegment(String segment) {
        IStatus val = CConventions.validateIdentifier(segment);
        return val.getSeverity() != 4;
    }

    public int hashCode() {
        String name;
        if (this.fHashCode == 0 && (name = this.getFullyQualifiedName()) != null) {
            this.fHashCode = name.hashCode();
        }
        return this.fHashCode;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof IQualifiedTypeName)) {
            throw new ClassCastException();
        }
        IQualifiedTypeName typeName = (IQualifiedTypeName)obj;
        return this.getFullyQualifiedName().compareTo(typeName.getFullyQualifiedName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IQualifiedTypeName)) {
            return false;
        }
        IQualifiedTypeName typeName = (IQualifiedTypeName)obj;
        return QualifiedTypeName.matchSegments(this.fSegments, typeName.segments());
    }

    private static boolean matchSegments(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

