/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.ResolverModel;

public class CFileTypeResolver
implements ICFileTypeResolver {
    protected List fAssocList = new ArrayList();

    public ICFileTypeAssociation[] getFileTypeAssociations() {
        return this.fAssocList.toArray(new ICFileTypeAssociation[this.fAssocList.size()]);
    }

    public ICFileType getFileType(String fileName) {
        Iterator iter = this.fAssocList.iterator();
        while (iter.hasNext()) {
            ICFileTypeAssociation element = (ICFileTypeAssociation)iter.next();
            if (!element.matches(fileName)) continue;
            return element.getType();
        }
        return ResolverModel.DEFAULT_FILE_TYPE;
    }

    public boolean addAssociation(ICFileTypeAssociation assoc) {
        return this.addAssociations(new ICFileTypeAssociation[]{assoc});
    }

    public boolean addAssociations(ICFileTypeAssociation[] assocs) {
        return this.doAddAssociations(assocs);
    }

    public boolean removeAssociation(ICFileTypeAssociation assoc) {
        return this.removeAssociations(new ICFileTypeAssociation[]{assoc});
    }

    public boolean removeAssociations(ICFileTypeAssociation[] assocs) {
        return this.doRemoveAssociations(assocs);
    }

    public boolean adjustAssociations(ICFileTypeAssociation[] add, ICFileTypeAssociation[] remove) {
        boolean added = this.doAddAssociations(add);
        boolean removed = this.doRemoveAssociations(remove);
        return added || removed;
    }

    public ICFileTypeResolver createWorkingCopy() {
        CFileTypeResolver copy = new CFileTypeResolver();
        copy.fAssocList.addAll(this.fAssocList);
        return copy;
    }

    protected boolean doAddAssociations(ICFileTypeAssociation[] assocs) {
        boolean added = false;
        if (assocs != null) {
            int i = 0;
            while (i < assocs.length) {
                if (!this.fAssocList.contains(assocs[i]) && this.fAssocList.add(assocs[i])) {
                    added = true;
                }
                ++i;
            }
        }
        if (added) {
            Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
        }
        return added;
    }

    public boolean doRemoveAssociations(ICFileTypeAssociation[] assocs) {
        boolean removed = false;
        if (assocs != null) {
            int i = 0;
            while (i < assocs.length) {
                if (this.fAssocList.remove(assocs[i])) {
                    removed = true;
                }
                ++i;
            }
        }
        if (removed) {
            Collections.sort(this.fAssocList, ICFileTypeAssociation.Comparator);
        }
        return removed;
    }

    private static boolean isDebugging() {
        return ResolverModel.VERBOSE;
    }

    private static void debugLog(String message) {
        System.out.println("CDT Resolver: " + message);
    }
}

