/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.internal.core.model.BatchOperation;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ContainerEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.internal.core.model.LibraryEntry;
import org.eclipse.cdt.internal.core.model.MacroEntry;
import org.eclipse.cdt.internal.core.model.OutputEntry;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.ProjectEntry;
import org.eclipse.cdt.internal.core.model.SourceEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreModel {
    private static CoreModel cmodel = null;
    private static CModelManager manager = CModelManager.getDefault();
    private static PathEntryManager pathEntryManager = PathEntryManager.getDefault();
    public static final String CORE_MODEL_ID = "org.eclipse.cdt.core.coremodel";

    public ICElement create(IPath path) {
        return manager.create(path);
    }

    public ITranslationUnit createTranslationUnitFrom(ICProject cproject, IPath path) {
        return manager.createTranslationUnitFrom(cproject, path);
    }

    public ICElement create(IFile file) {
        return manager.create(file, null);
    }

    public ICContainer create(IFolder folder) {
        return manager.create(folder, null);
    }

    public ICProject create(IProject project) {
        if (project == null) {
            return null;
        }
        CModel cModel = manager.getCModel();
        return cModel.getCProject((IResource)project);
    }

    public ICElement create(IResource resource) {
        return manager.create(resource, null);
    }

    public static ICModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return manager.getCModel();
    }

    public ICModel getCModel() {
        return manager.getCModel();
    }

    public boolean isSharedLib(IFile file) {
        ICElement celement = this.create(file);
        if (celement instanceof IBinary) {
            return ((IBinary)celement).isSharedLib();
        }
        return false;
    }

    public boolean isObject(IFile file) {
        ICElement celement = this.create(file);
        if (celement instanceof IBinary) {
            return ((IBinary)celement).isObject();
        }
        return false;
    }

    public boolean isExecutable(IFile file) {
        ICElement celement = this.create(file);
        if (celement instanceof IBinary) {
            return ((IBinary)celement).isExecutable();
        }
        return false;
    }

    public boolean isBinary(IFile file) {
        ICElement celement = this.create(file);
        return celement instanceof IBinary;
    }

    public boolean isArchive(IFile file) {
        ICElement celement = this.create(file);
        return celement instanceof IArchive;
    }

    public static boolean isTranslationUnit(IFile file) {
        IProject p;
        if (file != null && (CoreModel.hasCNature(p = file.getProject()) || CoreModel.hasCCNature(p))) {
            ICFileType type = CCorePlugin.getDefault().getFileType(file.getProject(), file.getName());
            return type.isTranslationUnit();
        }
        return false;
    }

    public static boolean isValidTranslationUnitName(IProject project, String name) {
        ICFileType type = CCorePlugin.getDefault().getFileType(project, name);
        return type.isTranslationUnit();
    }

    public static boolean isValidHeaderUnitName(IProject project, String name) {
        ICFileType type = CCorePlugin.getDefault().getFileType(project, name);
        return type.isHeader();
    }

    public static boolean isValidSourceUnitName(IProject project, String name) {
        ICFileType type = CCorePlugin.getDefault().getFileType(project, name);
        return type.isSource();
    }

    public static boolean hasCNature(IProject project) {
        boolean ok = false;
        try {
            ok = project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {}
        return ok;
    }

    public static boolean hasCCNature(IProject project) {
        boolean ok = false;
        try {
            ok = project.isOpen() && project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {}
        return ok;
    }

    public static IProjectEntry newProjectEntry(IPath projectPath) {
        return CoreModel.newProjectEntry(projectPath, false);
    }

    public static IProjectEntry newProjectEntry(IPath projectPath, boolean isExported) {
        return new ProjectEntry(projectPath, isExported);
    }

    public static IContainerEntry newContainerEntry(IPath id) {
        return CoreModel.newContainerEntry(id, false);
    }

    public static IContainerEntry newContainerEntry(IPath id, boolean isExported) {
        return new ContainerEntry(id, isExported);
    }

    public static ILibraryEntry newLibraryRefEntry(IPath resourcePath, IPath baseRef, IPath libraryPath) {
        return new LibraryEntry(resourcePath, null, baseRef, libraryPath, null, null, null, false);
    }

    public static ILibraryEntry newLibraryEntry(IPath resourcePath, IPath basePath, IPath libraryPath, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping, boolean isExported) {
        return new LibraryEntry(resourcePath, basePath, null, libraryPath, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping, isExported);
    }

    public static IOutputEntry newOutputEntry(IPath outputPath) {
        return CoreModel.newOutputEntry(outputPath, OutputEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IOutputEntry newOutputEntry(IPath outputPath, IPath[] exclusionPatterns) {
        return new OutputEntry(outputPath, exclusionPatterns, false);
    }

    public static ISourceEntry newSourceEntry(IPath sourcePath) {
        return CoreModel.newSourceEntry(sourcePath, SourceEntry.NO_EXCLUSION_PATTERNS);
    }

    public static ISourceEntry newSourceEntry(IPath sourcePath, IPath[] exclusionPatterns) {
        return new SourceEntry(sourcePath, exclusionPatterns);
    }

    public static IIncludeEntry newIncludeEntry(IPath resourcePath, IPath basePath, IPath includePath) {
        return CoreModel.newIncludeEntry(resourcePath, basePath, includePath, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath resourcePath, IPath basePath, IPath includePath, boolean isSystemInclude) {
        return CoreModel.newIncludeEntry(resourcePath, basePath, includePath, isSystemInclude, IncludeEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IIncludeEntry newIncludeEntry(IPath resourcePath, IPath basePath, IPath includePath, boolean isSystemInclude, IPath[] exclusionPatterns) {
        return CoreModel.newIncludeEntry(resourcePath, basePath, includePath, isSystemInclude, exclusionPatterns, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath resourcePath, IPath basePath, IPath includePath, boolean isSystemInclude, IPath[] exclusionPatterns, boolean isExported) {
        return new IncludeEntry(resourcePath, basePath, null, includePath, isSystemInclude, exclusionPatterns, isExported);
    }

    public static IIncludeEntry newIncludeRefEntry(IPath resourcePath, IPath baseRef, IPath includePath) {
        return new IncludeEntry(resourcePath, null, baseRef, includePath, false, null, false);
    }

    public static IMacroEntry newMacroEntry(IPath resourcePath, String macroName, String macroValue) {
        return CoreModel.newMacroEntry(resourcePath, macroName, macroValue, MacroEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IMacroEntry newMacroEntry(IPath resourcePath, String macroName, String macroValue, IPath[] exclusionPatterns) {
        return CoreModel.newMacroEntry(resourcePath, macroName, macroValue, exclusionPatterns, false);
    }

    public static IMacroEntry newMacroEntry(IPath resourcePath, String macroName, String macroValue, IPath[] exclusionPatterns, boolean isExported) {
        return new MacroEntry(resourcePath, null, macroName, macroValue, exclusionPatterns, isExported);
    }

    public static IMacroEntry newMacroRefEntry(IPath resourcePath, IPath baseRef, String macroName) {
        return new MacroEntry(resourcePath, baseRef, macroName, null, MacroEntry.NO_EXCLUSION_PATTERNS, false);
    }

    public static IPathEntryContainer getPathEntryContainer(IPath containerPath, ICProject project) throws CModelException {
        return pathEntryManager.getPathEntryContainer(containerPath, project);
    }

    public void setPathEntryContainer(ICProject[] affectedProjects, IPathEntryContainer container, IProgressMonitor monitor) throws CModelException {
        pathEntryManager.setPathEntryContainer(affectedProjects, container, monitor);
    }

    public static void setRawPathEntries(ICProject cproject, IPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        pathEntryManager.setRawPathEntries(cproject, newEntries, monitor);
    }

    public static IPathEntry[] getRawPathEntries(ICProject cproject) throws CModelException {
        return pathEntryManager.getRawPathEntries(cproject);
    }

    public static IPathEntry[] getResolvedPathEntries(ICProject cproject) throws CModelException {
        return pathEntryManager.getResolvedPathEntries(cproject);
    }

    public static PathEntryContainerInitializer getPathEntryContainerInitializer(String containerID) {
        return pathEntryManager.getPathEntryContainerInitializer(containerID);
    }

    public static IPathEntryStore getPathEntryStore(IProject project) throws CoreException {
        return pathEntryManager.getPathEntryStore(project, true);
    }

    public static void setPathEntryStore(IProject project, IPathEntryStore store) {
        pathEntryManager.setPathEntryStore(project, store);
    }

    public static ICModelStatus validatePathEntries(ICProject cProject, IPathEntry[] entries) {
        return pathEntryManager.validatePathEntry(cProject, entries);
    }

    public static ICModelStatus validatePathEntry(ICProject cProject, IPathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        return pathEntryManager.validatePathEntry(cProject, entry, checkSourceAttachment, recurseInContainers);
    }

    public static CoreModel getDefault() {
        if (cmodel == null) {
            cmodel = new CoreModel();
        }
        return cmodel;
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        manager.addElementChangedListener(listener);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        manager.removeElementChangedListener(listener);
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    private CoreModel() {
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), monitor);
        }
    }

    public void startIndexing() {
        manager.getIndexManager().reset();
    }

    public IndexManager getIndexManager() {
        return manager.getIndexManager();
    }
}

