/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalTranslationUnit
extends TranslationUnit {
    IPath fPath;

    public ExternalTranslationUnit(ICElement parent, IPath path) {
        super(parent, path);
        this.fPath = path;
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IPath path = this.getPath();
            File file = path.toFile();
            if (file != null && file.isFile()) {
                try {
                    FileInputStream stream = new FileInputStream(file);
                    buffer.setContents(Util.getInputStreamAsCharArray(stream, (int)file.length(), null));
                }
                catch (IOException iOException) {
                    buffer.setContents(new char[0]);
                }
            } else {
                buffer.setContents(new char[0]);
            }
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public IPath getPath() {
        return this.fPath;
    }
}

