/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesMessages;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.sharedlibs.SharedLibrariesViewEventHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class SharedLibrariesView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    protected Viewer createViewer(Composite parent) {
        TableTreeViewer viewer = new TableTreeViewer(parent, 66306);
        Table table = viewer.getTableTree().getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[1].setResizable(true);
        columns[2].setResizable(true);
        columns[3].setResizable(true);
        columns[4].setResizable(true);
        columns[0].setText("");
        columns[1].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Name_1"));
        columns[2].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Symbols_1"));
        columns[3].setText(SharedLibrariesMessages.getString("SharedLibrariesView.Start_Address_1"));
        columns[4].setText(SharedLibrariesMessages.getString("SharedLibrariesView.End_Address_1"));
        PixelConverter pc = new PixelConverter((Control)parent);
        columns[0].setWidth(pc.convertWidthInCharsToPixels(3));
        columns[1].setWidth(pc.convertWidthInCharsToPixels(50));
        columns[2].setWidth(pc.convertWidthInCharsToPixels(20));
        columns[3].setWidth(pc.convertWidthInCharsToPixels(20));
        columns[4].setWidth(pc.convertWidthInCharsToPixels(20));
        viewer.setContentProvider(this.createContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SharedLibrariesLabelProvider());
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)viewer));
        return viewer;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SHARED_LIBRARIES_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptySharedLibrariesGroup"));
        menu.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        menu.add((IContributionItem)new Separator("emptyRefreshGroup"));
        menu.add((IContributionItem)new Separator("refreshGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("sharedLibrariesGroup"));
        tbm.add((IContributionItem)new Separator("refreshGroup"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        ICDebugTarget target = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement && ((IDebugElement)input).getDebugTarget() instanceof ICDebugTarget) {
            target = (ICDebugTarget)((IDebugElement)input).getDebugTarget();
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current != null && current.equals(target)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(target);
        this.updateObjects();
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new SharedLibrariesViewEventHandler(this);
    }

    protected IContentProvider createContentProvider() {
        SharedLibrariesViewContentProvider cp = new SharedLibrariesViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public class SharedLibrariesLabelProvider
    extends CDebugModelPresentation
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ICSharedLibrary && columnIndex == 1) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICSharedLibrary) {
                ICSharedLibrary library = (ICSharedLibrary)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return this.getText(element);
                    }
                    case 2: {
                        return library.areSymbolsLoaded() ? SharedLibrariesMessages.getString("SharedLibrariesView.Loaded_1") : SharedLibrariesMessages.getString("SharedLibrariesView.Not_loaded_1");
                    }
                    case 3: {
                        return library.getStartAddress() > 0L ? CDebugUIUtils.toHexAddressString(library.getStartAddress()) : "";
                    }
                    case 4: {
                        return library.getEndAddress() > 0L ? CDebugUIUtils.toHexAddressString(library.getEndAddress()) : "";
                    }
                }
            }
            return null;
        }
    }
}

