/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;

public class ASTInclusion
implements IASTInclusion {
    private int nameEndOffset;
    private final String name;
    private final String fileName;
    private final boolean local;
    private int startingOffset = 0;
    private int nameOffset = 0;
    private int endingOffset = 0;
    private int startingLineNumber;
    private int endingLineNumber;
    private int nameLineNumber;
    private int fileIndex;

    public ASTInclusion(String name, String fileName, boolean local, int startingOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endLine) {
        this.name = name;
        this.fileName = fileName;
        this.local = local;
        this.setStartingOffsetAndLineNumber(startingOffset, startLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.setEndingOffsetAndLineNumber(endOffset, endLine);
    }

    public String getName() {
        return this.name;
    }

    public String getFullFileName() {
        return this.fileName;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public void setNameOffset(int o) {
        this.nameOffset = o;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterInclusion(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitInclusion(this);
        }
        catch (Exception exception) {}
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int index) {
        this.fileIndex = index;
    }
}

