/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.expression;

import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.internal.core.parser.ast.GCCASTExtension;
import org.eclipse.cdt.internal.core.parser.ast.expression.ASTBinaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.expression.ASTIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.expression.ASTTypeIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.expression.ASTUnaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.expression.ExpressionFactory;

public class GCCASTExpressionExtension
extends GCCASTExtension {
    public GCCASTExpressionExtension(ParserMode mode) {
        super(mode);
    }

    public boolean overrideCreateExpressionMethod() {
        return this.mode == ParserMode.EXPRESSION_PARSE;
    }

    private static IASTExpression createExpression(IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, String idExpression, String literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor) {
        if (!idExpression.equals("") && literal.equals("")) {
            return new ASTIdExpression(kind, idExpression){

                public long evaluateExpression() throws ASTExpressionEvaluationException {
                    if (this.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION) {
                        return 0L;
                    }
                    return super.evaluateExpression();
                }
            };
        }
        if (lhs != null && rhs != null && (kind == IASTGCCExpression.Kind.RELATIONAL_MAX || kind == IASTGCCExpression.Kind.RELATIONAL_MIN)) {
            return new ASTBinaryExpression(kind, lhs, rhs){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(ASTUtil.getExpressionString(this.getLHSExpression()));
                    if (k == IASTGCCExpression.Kind.RELATIONAL_MAX) {
                        buffer.append(" >? ");
                    } else {
                        buffer.append(" <? ");
                    }
                    buffer.append(ASTUtil.getExpressionString(this.getRHSExpression()));
                    return buffer.toString();
                }
            };
        }
        if (lhs != null && (kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION)) {
            return new ASTUnaryExpression(kind, lhs){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    if (k == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION) {
                        buffer.append("__alignof__");
                    } else {
                        buffer.append("typeof");
                    }
                    buffer.append(' ');
                    buffer.append(ASTUtil.getExpressionString(this.getLHSExpression()));
                    return buffer.toString();
                }
            };
        }
        if (typeId != null && lhs == null && (kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID)) {
            return new ASTTypeIdExpression(kind, typeId){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    if (k == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID) {
                        buffer.append("__alignof__");
                    } else {
                        buffer.append("typeof");
                    }
                    buffer.append('(');
                    buffer.append(ASTUtil.getTypeId(this.getTypeId()));
                    buffer.append(')');
                    return buffer.toString();
                }
            };
        }
        return ExpressionFactory.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor);
    }

    public IASTExpression createExpression(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, String literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor, List references) {
        return GCCASTExpressionExtension.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression == null ? "" : idExpression.toString(), literal, newDescriptor);
    }
}

