/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.DeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.DerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TemplateSymbol
extends ParameterizedSymbol
implements ITemplateSymbol {
    private List _specializations = Collections.EMPTY_LIST;
    private Map _explicitSpecializations = Collections.EMPTY_MAP;
    private Map _defnParameterMap = Collections.EMPTY_MAP;
    private Map _instantiations = Collections.EMPTY_MAP;
    private List _deferredInstantiations = Collections.EMPTY_LIST;
    private boolean _processingDeferred = false;

    protected TemplateSymbol(ParserSymbolTable table, String name) {
        super(table, name, TypeInfo.t_template);
    }

    protected TemplateSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    public Object clone() {
        TemplateSymbol copy = (TemplateSymbol)super.clone();
        copy._defnParameterMap = this._defnParameterMap != Collections.EMPTY_MAP ? (Map)((HashMap)this._defnParameterMap).clone() : this._defnParameterMap;
        copy._instantiations = this._instantiations != Collections.EMPTY_MAP ? (Map)((HashMap)this._instantiations).clone() : this._instantiations;
        return copy;
    }

    public IContainerSymbol getTemplatedSymbol() {
        Iterator iter = this.getContentsIterator();
        if (iter.hasNext()) {
            IContainerSymbol contained = (IContainerSymbol)iter.next();
            return contained;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISymbol instantiate(List arguments) throws ParserSymbolTableException {
        void var10_11;
        List paramList;
        if (this.getType() != TypeInfo.t_template && (this.getType() != TypeInfo.t_templateParameter || this.getTypeInfo().getTemplateParameterType() != TypeInfo.t_template)) {
            return null;
        }
        ITemplateSymbol template = TemplateEngine.matchTemplatePartialSpecialization(this, arguments);
        if (template != null && template instanceof ISpecializedSymbol) {
            return template.instantiate(arguments);
        }
        if (template == null) {
            template = this;
        }
        int numParams = (paramList = template.getParameterList()) != null ? paramList.size() : 0;
        int numArgs = arguments.size();
        if (numParams == 0) {
            return null;
        }
        HashMap<ISymbol, TypeInfo> map = new HashMap<ISymbol, TypeInfo>();
        ISymbol param = null;
        TypeInfo arg = null;
        ArrayList<TypeInfo> actualArgs = new ArrayList<TypeInfo>(numParams);
        IContainerSymbol iContainerSymbol = template.getTemplatedSymbol();
        while (var10_11 != null && var10_11.isTemplateInstance()) {
            ISymbol iSymbol = var10_11.getInstantiatedSymbol();
        }
        int i = 0;
        while (i < numParams) {
            param = (ISymbol)paramList.get(i);
            param = TemplateEngine.translateParameterForDefinition((ISymbol)var10_11, param, this.getDefinitionParameterMap());
            if (i < numArgs) {
                arg = (TypeInfo)arguments.get(i);
                if (arg.isType(TypeInfo.t_type)) {
                    if (arg.getTypeSymbol() == null) {
                        throw new ParserSymbolTableException(8);
                    }
                    if (arg.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                        return this.deferredInstance(arguments);
                    }
                }
            } else {
                Object obj = param.getTypeInfo().getDefault();
                if (obj == null || !(obj instanceof TypeInfo)) throw new ParserSymbolTableException(8);
                arg = (TypeInfo)obj;
                if (arg.isType(TypeInfo.t_type) && arg.getTypeSymbol().isType(TypeInfo.t_templateParameter)) {
                    if (!map.containsKey(arg.getTypeSymbol())) throw new ParserSymbolTableException(8);
                    arg = (TypeInfo)map.get(arg.getTypeSymbol());
                } else if (arg.isType(TypeInfo.t_type) && arg.getTypeSymbol() instanceof IDeferredTemplateInstance) {
                    IDeferredTemplateInstance deferred = (IDeferredTemplateInstance)arg.getTypeSymbol();
                    arg = new TypeInfo(arg);
                    arg.setTypeSymbol(deferred.instantiate(this, map));
                }
            }
            if (!TemplateEngine.matchTemplateParameterAndArgument(param, arg)) {
                throw new ParserSymbolTableException(8);
            }
            map.put(param, arg);
            actualArgs.add(arg);
            ++i;
        }
        IContainerSymbol instance = this.findInstantiation(actualArgs);
        if (instance != null) {
            return instance;
        }
        if (template.isType(TypeInfo.t_templateParameter)) {
            return this.deferredInstance(arguments);
        }
        IContainerSymbol symbol = template.getTemplatedSymbol();
        ISymbol temp = TemplateEngine.checkForTemplateExplicitSpecialization(template, symbol, actualArgs);
        symbol = (IContainerSymbol)(temp != null ? temp : symbol);
        instance = (IContainerSymbol)symbol.instantiate(template, map);
        this.addInstantiation(instance, actualArgs);
        try {
            this.processDeferredInstantiations();
            return instance;
        }
        catch (ParserSymbolTableException e) {
            if (e.reason != 11) throw e;
            this.removeInstantiation(instance);
            throw e;
        }
    }

    public ISymbol instantiate(ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        TemplateSymbol newTemplate = (TemplateSymbol)super.instantiate(template, argMap);
        List parameters = newTemplate.getParameterList();
        int size = parameters.size();
        ISymbol param = null;
        int i = 0;
        while (i < size) {
            param = (ISymbol)parameters.get(i);
            Object obj = param.getTypeInfo().getDefault();
            if (obj instanceof TypeInfo) {
                param.getTypeInfo().setDefault(TemplateEngine.instantiateTypeInfo((TypeInfo)obj, template, argMap));
            }
            ++i;
        }
        return newTemplate;
    }

    public void addParameter(ISymbol param) {
        throw new ParserSymbolTableError(0);
    }

    public void addTemplateParameter(ISymbol param) throws ParserSymbolTableException {
        if (this.isType(TypeInfo.t_template) || this.getTypeInfo().getTemplateParameterType() == TypeInfo.t_template) {
            if (!this.isAllowableTemplateParameter(param)) {
                throw new ParserSymbolTableException(9);
            }
            this.modifyTemplateParameter(param);
        }
        super.addParameter(param);
    }

    private boolean isAllowableTemplateParameter(ISymbol param) {
        TypeInfo info;
        if (!param.isType(TypeInfo.t_templateParameter)) {
            return false;
        }
        if (!this.getName().equals("") && param.getName().equals(this.getName())) {
            return false;
        }
        return param.getTypeInfo().getTemplateParameterType() == TypeInfo.t_typeName || param.getTypeInfo().getTemplateParameterType() == TypeInfo.t_template || (info = param.getTypeInfo()).getPtrOperators().size() != 0 || info.getTemplateParameterType() != TypeInfo.t_float && info.getTemplateParameterType() != TypeInfo.t_double && info.getTemplateParameterType() != TypeInfo.t_class && info.getTemplateParameterType() != TypeInfo.t_struct && info.getTemplateParameterType() != TypeInfo.t_union && info.getTemplateParameterType() != TypeInfo.t_enumeration && info.getTemplateParameterType() != TypeInfo.t_void;
    }

    private void modifyTemplateParameter(ISymbol param) {
        List ptrs = param.getPtrOperators();
        if (ptrs.size() > 0) {
            TypeInfo.PtrOp op = (TypeInfo.PtrOp)ptrs.get(0);
            if (op.getType() == TypeInfo.PtrOp.t_array) {
                op.setType(TypeInfo.PtrOp.t_pointer);
            }
        } else if (param.isType(TypeInfo.t_type) && param.getTypeSymbol().isType(TypeInfo.t_function)) {
            param.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        }
    }

    public boolean hasSpecializations() {
        return !this._specializations.isEmpty();
    }

    public void addExplicitSpecialization(ISymbol symbol, List args) throws ParserSymbolTableException {
        List actualArgs = TemplateEngine.verifyExplicitArguments(this, args, symbol);
        if (this._explicitSpecializations == Collections.EMPTY_MAP) {
            this._explicitSpecializations = new HashMap();
        }
        Map<ISymbol, ISymbol> specs = null;
        List key = null;
        Iterator iter = this._explicitSpecializations.keySet().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            if (!list.equals(args)) continue;
            key = list;
            break;
        }
        if (key != null) {
            specs = (Map)this._explicitSpecializations.get(key);
        } else {
            specs = new HashMap();
            this._explicitSpecializations.put(new ArrayList(actualArgs), specs);
        }
        ISymbol found = null;
        try {
            if (symbol.isType(TypeInfo.t_function) || symbol.isType(TypeInfo.t_constructor)) {
                List params = ((IParameterizedSymbol)symbol).getParameterList();
                int size = params.size();
                ArrayList<TypeInfo> fnArgs = new ArrayList<TypeInfo>(size);
                int i = 0;
                while (i < size) {
                    fnArgs.add(((ISymbol)params.get(i)).getTypeInfo());
                    ++i;
                }
                found = this.getTemplatedSymbol().lookupMethodForDefinition(symbol.getName(), fnArgs);
            } else {
                found = this.getTemplatedSymbol().lookupMemberForDefinition(symbol.getName());
            }
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        if (found == null && this.getTemplatedSymbol().getName().equals(symbol.getName())) {
            found = this.getTemplatedSymbol();
            IContainerSymbol instance = this.findInstantiation(actualArgs);
            if (instance != null) {
                this._instantiations.remove(this.findArgumentsFor(instance));
            }
        }
        if (found != null) {
            if (found.getTypeInfo().isForwardDeclaration() && found.getTypeSymbol() == symbol) {
                found.setTypeSymbol(null);
            }
            while (found.isTemplateInstance()) {
                found = found.getInstantiatedSymbol();
            }
        }
        if (found != null) {
            symbol.setIsTemplateMember(true);
            symbol.setContainingSymbol(found.getContainingSymbol());
            specs.put(found, symbol);
        }
    }

    public void addSpecialization(ISpecializedSymbol spec) {
        if (this._specializations == Collections.EMPTY_LIST) {
            this._specializations = new ArrayList(4);
        }
        this._specializations.add(spec);
        spec.setContainingSymbol(this.getContainingSymbol());
        spec.setPrimaryTemplate(this);
    }

    public List getSpecializations() {
        return this._specializations;
    }

    public void addInstantiation(IContainerSymbol instance, List args) {
        ArrayList key = new ArrayList(args);
        if (this._instantiations == Collections.EMPTY_MAP) {
            this._instantiations = new HashMap();
        }
        this._instantiations.put(key, instance);
    }

    public IContainerSymbol findInstantiation(List arguments) {
        if (this._instantiations == Collections.EMPTY_MAP) {
            return null;
        }
        Iterator iter = this._instantiations.keySet().iterator();
        List args = null;
        while (iter.hasNext()) {
            args = (List)iter.next();
            if (!args.equals(arguments)) continue;
            return (IContainerSymbol)this._instantiations.get(args);
        }
        return null;
    }

    public List findArgumentsFor(IContainerSymbol instance) {
        if (instance == null || !instance.isTemplateInstance()) {
            return null;
        }
        ITemplateSymbol template = (ITemplateSymbol)instance.getInstantiatedSymbol().getContainingSymbol();
        if (template != this) {
            return null;
        }
        Iterator iter = this._instantiations.keySet().iterator();
        while (iter.hasNext()) {
            List args = (List)iter.next();
            if (this._instantiations.get(args) != instance) continue;
            return args;
        }
        return null;
    }

    public void removeInstantiation(IContainerSymbol symbol) {
        List args = this.findArgumentsFor(symbol);
        if (args != null) {
            this._instantiations.remove(args);
        }
    }

    public Map getDefinitionParameterMap() {
        return this._defnParameterMap;
    }

    protected void addToDefinitionParameterMap(ISymbol newSymbol, Map defnMap) {
        if (this._defnParameterMap == Collections.EMPTY_MAP) {
            this._defnParameterMap = new HashMap();
        }
        this._defnParameterMap.put(newSymbol, defnMap);
    }

    public IDeferredTemplateInstance deferredInstance(List args) {
        return new DeferredTemplateInstance(this.getSymbolTable(), this, args);
    }

    public Map getExplicitSpecializations() {
        return this._explicitSpecializations;
    }

    public void registerDeferredInstatiation(Object obj0, Object obj1, ITemplateSymbol.DeferredKind kind, Map argMap) {
        if (this._deferredInstantiations == Collections.EMPTY_LIST) {
            this._deferredInstantiations = new ArrayList(8);
        }
        this._deferredInstantiations.add(new Object[]{obj0, obj1, kind, argMap});
    }

    public int getNumberDeferredInstantiations() {
        return this._deferredInstantiations.size();
    }

    protected void processDeferredInstantiations() throws ParserSymbolTableException {
        if (this._deferredInstantiations == Collections.EMPTY_LIST) {
            return;
        }
        if (this._processingDeferred) {
            return;
        }
        this._processingDeferred = true;
        int numDeferred = this._deferredInstantiations.size();
        int numProcessed = 0;
        int loopCount = 0;
        while (numDeferred > numProcessed) {
            int i = numProcessed;
            while (i < numDeferred) {
                Object[] objs = (Object[])this._deferredInstantiations.get(i);
                ITemplateSymbol.DeferredKind kind = (ITemplateSymbol.DeferredKind)objs[2];
                if (kind == ITemplateSymbol.DeferredKind.PARENT) {
                    DerivableContainerSymbol d = (DerivableContainerSymbol)objs[0];
                    d.instantiateDeferredParent((ISymbol)objs[1], this, (Map)objs[3]);
                } else if (kind == ITemplateSymbol.DeferredKind.RETURN_TYPE) {
                    ParameterizedSymbol p = (ParameterizedSymbol)objs[0];
                    p.instantiateDeferredReturnType((ISymbol)objs[1], this, (Map)objs[3]);
                } else if (kind == ITemplateSymbol.DeferredKind.TYPE_SYMBOL) {
                    TemplateEngine.instantiateDeferredTypeInfo((TypeInfo)objs[0], this, (Map)objs[3]);
                }
                ++numProcessed;
                ++i;
            }
            numDeferred = this._deferredInstantiations.size();
            if (++loopCount <= 10) continue;
            this.discardDeferredInstantiations();
            this._processingDeferred = false;
            throw new ParserSymbolTableException(11);
        }
        this._processingDeferred = false;
    }

    private void discardDeferredInstantiations() {
        int size = this._deferredInstantiations.size();
        int i = 0;
        while (i < size) {
            Object[] objs = (Object[])this._deferredInstantiations.get(i);
            ITemplateSymbol.DeferredKind kind = (ITemplateSymbol.DeferredKind)objs[2];
            if (kind == ITemplateSymbol.DeferredKind.PARENT) {
                DerivableContainerSymbol d = (DerivableContainerSymbol)objs[0];
                d.discardDeferredParent((IDeferredTemplateInstance)objs[1], this, (Map)objs[3]);
            } else if (kind == ITemplateSymbol.DeferredKind.RETURN_TYPE) {
                ParameterizedSymbol p = (ParameterizedSymbol)objs[0];
                p.discardDeferredReturnType((ISymbol)objs[1], this, (Map)objs[3]);
            } else if (kind == ITemplateSymbol.DeferredKind.TYPE_SYMBOL) {
                TemplateEngine.discardDeferredTypeInfo((TypeInfo)objs[0], this, (Map)objs[3]);
            }
            ++i;
        }
        this._deferredInstantiations.clear();
    }
}

