/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeInfoVisitor;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacherJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeLocatorJob;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class TypeCache
implements ITypeCache {
    private static final int INITIAL_TYPE_COUNT = 100;
    private final Map fTypeKeyMap = new HashMap(100);
    private final IProject fProject;
    private final IWorkingCopyProvider fWorkingCopyProvider;
    private final Collection fDeltas = new ArrayList();
    private final ITypeInfo fGlobalNamespace;
    private static final int[] ENCLOSING_TYPES;
    private IJobChangeListener fJobChangeListener = new IJobChangeListener(){

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            if (job instanceof TypeCacherJob) {
                TypeCacherJob deltaJob = (TypeCacherJob)job;
                IStatus status = event.getResult();
                if (status != null) {
                    boolean jobFinished = status.equals(Status.OK_STATUS);
                    Collection collection = TypeCache.this.fDeltas;
                    synchronized (collection) {
                        Iterator i = TypeCache.this.fDeltas.iterator();
                        while (i.hasNext()) {
                            TypeCacheDelta delta = (TypeCacheDelta)i.next();
                            if (delta.getJob() == null || !((Object)((Object)delta.getJob())).equals((Object)deltaJob)) continue;
                            if (jobFinished) {
                                i.remove();
                                continue;
                            }
                            delta.assignToJob(null);
                        }
                    }
                }
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    };

    static {
        int[] nArray = new int[4];
        nArray[0] = 61;
        nArray[1] = 64;
        nArray[2] = 65;
        ENCLOSING_TYPES = nArray;
    }

    public TypeCache(IProject project, IWorkingCopyProvider workingCopyProvider) {
        this.fProject = project;
        this.fWorkingCopyProvider = workingCopyProvider;
        this.fDeltas.add(new TypeCacheDelta(this.fProject));
        this.fGlobalNamespace = new TypeInfo(61, new GlobalNamespace());
        this.fGlobalNamespace.setCache(this);
    }

    public boolean contains(ISchedulingRule rule) {
        ITypeCache typeCache;
        if (this == rule) {
            return true;
        }
        return rule instanceof ITypeCache && this.fProject.equals((Object)(typeCache = (ITypeCache)rule).getProject());
    }

    public boolean isConflicting(ISchedulingRule rule) {
        ITypeCache typeCache;
        return rule instanceof ITypeCache && this.fProject.equals((Object)(typeCache = (ITypeCache)rule).getProject());
    }

    public IProject getProject() {
        return this.fProject;
    }

    public synchronized boolean isEmpty() {
        return this.fTypeKeyMap.isEmpty();
    }

    public synchronized void insert(ITypeInfo newType) {
        IQualifiedTypeName enclosingName = newType.getQualifiedTypeName().getEnclosingTypeName();
        if (enclosingName != null) {
            while (!enclosingName.isEmpty()) {
                ITypeInfo enclosingType = null;
                int i = 0;
                while (enclosingType == null && i < ENCLOSING_TYPES.length) {
                    enclosingType = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(enclosingName, ENCLOSING_TYPES[i]));
                    ++i;
                }
                if (enclosingType == null) {
                    TypeInfo dummyType = new TypeInfo(0, enclosingName);
                    dummyType.setCache(this);
                    this.fTypeKeyMap.put(new HashKey(enclosingName, 0), dummyType);
                }
                enclosingName = enclosingName.removeLastSegments(1);
            }
        }
        this.fTypeKeyMap.put(new HashKey(newType.getQualifiedTypeName(), newType.getCElementType()), newType);
        newType.setCache(this);
    }

    public synchronized void remove(ITypeInfo info) {
        this.fTypeKeyMap.remove(new HashKey(info.getQualifiedTypeName(), info.getCElementType()));
        info.setCache(null);
    }

    public synchronized void flush(ITypeSearchScope scope) {
        if (scope.encloses(this.fProject)) {
            this.flushAll();
        } else {
            Iterator mapIter = this.fTypeKeyMap.entrySet().iterator();
            while (mapIter.hasNext()) {
                Map.Entry entry = mapIter.next();
                ITypeInfo info = (ITypeInfo)entry.getValue();
                if (!info.isEnclosed(scope)) continue;
                mapIter.remove();
            }
        }
    }

    public synchronized void flush(IPath path) {
        TypeSearchScope scope = new TypeSearchScope();
        scope.add(path, false, null);
        this.flush(scope);
    }

    public synchronized void flushAll() {
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                info.setCache(null);
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        this.fTypeKeyMap.clear();
    }

    public synchronized void accept(ITypeInfoVisitor visitor) {
        Iterator mapIter = this.fTypeKeyMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry entry = mapIter.next();
            ITypeInfo info = (ITypeInfo)entry.getValue();
            if (!visitor.shouldContinue()) {
                return;
            }
            visitor.visit(info);
        }
    }

    public synchronized IPath[] getPaths(final ITypeSearchScope scope) {
        final HashSet pathSet = new HashSet();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                ITypeReference[] refs;
                if ((scope == null || info.isEnclosed(scope)) && (refs = info.getReferences()) != null) {
                    int i = 0;
                    while (i < refs.length) {
                        IPath path = refs[i].getPath();
                        if (scope == null || scope.encloses(path)) {
                            pathSet.add(path);
                        }
                        ++i;
                    }
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return pathSet.toArray(new IPath[pathSet.size()]);
    }

    public synchronized ITypeInfo[] getTypes(final ITypeSearchScope scope) {
        final ArrayList results = new ArrayList();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (scope == null || info.isEnclosed(scope)) {
                    results.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return results.toArray(new ITypeInfo[results.size()]);
    }

    public synchronized ITypeInfo[] getTypes(IQualifiedTypeName qualifiedName) {
        ArrayList<ITypeInfo> results = new ArrayList<ITypeInfo>();
        int i = 0;
        while (i < ITypeInfo.KNOWN_TYPES.length) {
            ITypeInfo info = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(qualifiedName, ITypeInfo.KNOWN_TYPES[i]));
            if (info != null) {
                results.add(info);
            }
            ++i;
        }
        ITypeInfo info = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(qualifiedName, 0));
        if (info != null) {
            results.add(info);
        }
        return results.toArray(new ITypeInfo[results.size()]);
    }

    public synchronized ITypeInfo getType(int type, IQualifiedTypeName qualifiedName) {
        ITypeInfo info = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(qualifiedName, type));
        if (info == null && type != 0) {
            info = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(qualifiedName, 0));
        }
        return info;
    }

    public synchronized ITypeInfo getEnclosingType(ITypeInfo info, int[] kinds) {
        IQualifiedTypeName enclosingName = info.getQualifiedTypeName().getEnclosingTypeName();
        if (enclosingName != null) {
            ITypeInfo enclosingType = null;
            int i = 0;
            while (enclosingType == null && i < ENCLOSING_TYPES.length) {
                if (ArrayUtil.contains(kinds, ENCLOSING_TYPES[i])) {
                    enclosingType = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(enclosingName, ENCLOSING_TYPES[i]));
                }
                ++i;
            }
            return enclosingType;
        }
        return null;
    }

    public synchronized ITypeInfo getRootNamespace(ITypeInfo info, boolean includeGlobalNamespace) {
        IQualifiedTypeName qualifiedName = info.getQualifiedTypeName();
        if (qualifiedName.isGlobal()) {
            if (info.getCElementType() == 61) {
                return info;
            }
            if (includeGlobalNamespace) {
                return this.fGlobalNamespace;
            }
            return null;
        }
        IQualifiedTypeName namespace = qualifiedName.removeLastSegments(qualifiedName.segmentCount() - 1);
        ITypeInfo namespaceType = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(namespace, 61));
        if (namespaceType == null) {
            namespaceType = (ITypeInfo)this.fTypeKeyMap.get(new HashKey(namespace, 0));
        }
        return namespaceType;
    }

    public synchronized boolean hasEnclosedTypes(final ITypeInfo info) {
        final IQualifiedTypeName parentName = info.getQualifiedTypeName();
        final boolean[] foundTypes = new boolean[1];
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo type) {
                if (type != info && parentName.isPrefixOf(type.getQualifiedTypeName())) {
                    foundTypes[0] = true;
                }
                return true;
            }

            public boolean shouldContinue() {
                return !foundTypes[0];
            }
        });
        return foundTypes[0];
    }

    public synchronized ITypeInfo[] getEnclosedTypes(final ITypeInfo enclosedBy, final int[] kinds) {
        final IQualifiedTypeName parentName = enclosedBy.getQualifiedTypeName();
        final ArrayList results = new ArrayList();
        this.accept(new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo type) {
                if (ArrayUtil.contains(kinds, type.getCElementType())) {
                    IQualifiedTypeName enclosingName = type.getQualifiedTypeName().getEnclosingTypeName();
                    if (enclosedBy == TypeCache.this.fGlobalNamespace) {
                        if (enclosingName == null) {
                            results.add(type);
                        }
                    } else if (parentName.equals(enclosingName)) {
                        results.add(type);
                    }
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        });
        return results.toArray(new ITypeInfo[results.size()]);
    }

    public ITypeInfo getGlobalNamespace() {
        return this.fGlobalNamespace;
    }

    public boolean isUpToDate() {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            return this.fDeltas.isEmpty();
        }
    }

    public void addDelta(TypeCacheDelta delta) {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            this.fDeltas.add(delta);
        }
    }

    public void reconcile(boolean enableIndexing, int priority, int delay) {
        TypeCacherJob deltaJob;
        if (this.deltasRemaining() == 0) {
            return;
        }
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(TypeCacherJob.FAMILY);
        int i = 0;
        while (i < jobs.length) {
            TypeCacherJob deltaJob2 = (TypeCacherJob)jobs[i];
            if (deltaJob2.getCache().equals(this)) {
                deltaJob2.cancel();
            }
            ++i;
        }
        if (this.deltasRemaining() == 0) {
            return;
        }
        Collection collection = this.fDeltas;
        synchronized (collection) {
            TypeCacheDelta[] jobDeltas = this.fDeltas.toArray(new TypeCacheDelta[this.fDeltas.size()]);
            deltaJob = new TypeCacherJob(this, jobDeltas, enableIndexing);
            if (jobDeltas != null) {
                int i2 = 0;
                while (i2 < jobDeltas.length) {
                    jobDeltas[i2].assignToJob(deltaJob);
                    ++i2;
                }
            }
        }
        deltaJob.addJobChangeListener(this.fJobChangeListener);
        deltaJob.setPriority(priority);
        deltaJob.schedule(delay);
    }

    public void reconcileAndWait(boolean enableIndexing, int priority, IProgressMonitor monitor) {
        this.reconcile(enableIndexing, priority, 0);
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(TypeCacherJob.FAMILY);
        int i = 0;
        while (i < jobs.length) {
            TypeCacherJob deltaJob = (TypeCacherJob)jobs[i];
            if (deltaJob.getCache().equals(this)) {
                try {
                    deltaJob.join(monitor);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    private int deltasRemaining() {
        Collection collection = this.fDeltas;
        synchronized (collection) {
            int count = 0;
            Iterator i = this.fDeltas.iterator();
            while (i.hasNext()) {
                TypeCacheDelta delta = (TypeCacheDelta)i.next();
                TypeCacherJob job = delta.getJob();
                if (job != null && job.isRunning()) continue;
                ++count;
            }
            return count;
        }
    }

    public void cancelJobs() {
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(TypeCacherJob.FAMILY);
        int i = 0;
        while (i < jobs.length) {
            TypeCacherJob deltaJob = (TypeCacherJob)jobs[i];
            if (deltaJob.getCache().equals(this)) {
                deltaJob.cancel();
            }
            ++i;
        }
        jobs = jobManager.find(TypeLocatorJob.FAMILY);
        i = 0;
        while (i < jobs.length) {
            TypeLocatorJob locatorJob = (TypeLocatorJob)jobs[i];
            if (locatorJob.getType().getEnclosingProject().equals((Object)this.fProject)) {
                locatorJob.cancel();
            }
            ++i;
        }
    }

    public void locateType(ITypeInfo info, int priority, int delay) {
        ITypeReference location = info.getResolvedReference();
        if (location != null) {
            return;
        }
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(TypeLocatorJob.FAMILY);
        int i = 0;
        while (i < jobs.length) {
            TypeLocatorJob locatorJob = (TypeLocatorJob)jobs[i];
            if (locatorJob.getType().equals(info)) {
                locatorJob.cancel();
            }
            ++i;
        }
        location = info.getResolvedReference();
        if (location != null) {
            return;
        }
        TypeLocatorJob locatorJob = new TypeLocatorJob(info, this, this.fWorkingCopyProvider);
        locatorJob.setPriority(priority);
        locatorJob.schedule(delay);
    }

    public ITypeReference locateTypeAndWait(ITypeInfo info, int priority, IProgressMonitor monitor) {
        this.locateType(info, priority, 0);
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(TypeLocatorJob.FAMILY);
        int i = 0;
        while (i < jobs.length) {
            TypeLocatorJob locatorJob = (TypeLocatorJob)jobs[i];
            if (locatorJob.getType().equals(info)) {
                try {
                    locatorJob.join(monitor);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        return info.getResolvedReference();
    }

    private static class GlobalNamespace
    implements IQualifiedTypeName {
        private static final String GLOBAL_NAMESPACE = TypeCacheMessages.getString("TypeCache.globalNamespace");
        private static final String[] segments = new String[]{GLOBAL_NAMESPACE};

        public String getName() {
            return GLOBAL_NAMESPACE;
        }

        public String[] getEnclosingNames() {
            return null;
        }

        public String getFullyQualifiedName() {
            return GLOBAL_NAMESPACE;
        }

        public IQualifiedTypeName getEnclosingTypeName() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isGlobal() {
            return true;
        }

        public int segmentCount() {
            return 1;
        }

        public String[] segments() {
            return segments;
        }

        public String segment(int index) {
            if (index > 0) {
                return null;
            }
            return GLOBAL_NAMESPACE;
        }

        public String lastSegment() {
            return GLOBAL_NAMESPACE;
        }

        public int matchingFirstSegments(IQualifiedTypeName typeName) {
            return 1;
        }

        public boolean isPrefixOf(IQualifiedTypeName typeName) {
            return true;
        }

        public IQualifiedTypeName append(String[] names) {
            return new QualifiedTypeName(names);
        }

        public IQualifiedTypeName append(IQualifiedTypeName typeName) {
            return new QualifiedTypeName(typeName);
        }

        public IQualifiedTypeName append(String qualifiedName) {
            return new QualifiedTypeName(qualifiedName);
        }

        public IQualifiedTypeName removeFirstSegments(int count) {
            return this;
        }

        public IQualifiedTypeName removeLastSegments(int count) {
            return this;
        }

        public boolean isLowLevel() {
            return false;
        }

        public boolean validate() {
            return true;
        }

        public int hashCode() {
            return GLOBAL_NAMESPACE.hashCode();
        }

        public String toString() {
            return this.getFullyQualifiedName();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IQualifiedTypeName)) {
                return false;
            }
            IQualifiedTypeName typeName = (IQualifiedTypeName)obj;
            return typeName instanceof GlobalNamespace;
        }

        public int compareTo(Object obj) {
            if (obj == this) {
                return 0;
            }
            if (!(obj instanceof IQualifiedTypeName)) {
                throw new ClassCastException();
            }
            IQualifiedTypeName typeName = (IQualifiedTypeName)obj;
            return this.getFullyQualifiedName().compareTo(typeName.getFullyQualifiedName());
        }
    }

    private static class HashKey {
        private IQualifiedTypeName name;
        private int type;

        public HashKey(IQualifiedTypeName name, int type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return this.name.hashCode() + this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HashKey)) {
                return false;
            }
            HashKey otherKey = (HashKey)obj;
            return this.type == otherKey.type && this.name.equals(otherKey.name);
        }
    }
}

