/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeEntry
extends APathEntry
implements IIncludeEntry {
    IPath includePath;
    boolean isSystemInclude;

    public IncludeEntry(IPath resourcePath, IPath basePath, IPath baseRef, IPath includePath, boolean isSystemInclude, IPath[] exclusionPatterns, boolean isExported) {
        super(4, basePath, baseRef, resourcePath, exclusionPatterns, isExported);
        this.includePath = includePath == null ? Path.EMPTY : includePath;
        this.isSystemInclude = isSystemInclude;
    }

    public IPath getIncludePath() {
        return this.includePath;
    }

    public boolean isSystemInclude() {
        return this.isSystemInclude;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IIncludeEntry) {
            IIncludeEntry otherEntry = (IIncludeEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.path == null ? otherEntry.getPath() != null : !this.path.toString().equals(otherEntry.getPath().toString())) {
                return false;
            }
            if (this.includePath == null ? otherEntry.getIncludePath() != null : !this.includePath.toString().equals(otherEntry.getIncludePath().toString())) {
                return false;
            }
            return this.isSystemInclude == otherEntry.isSystemInclude();
        }
        return super.equals(obj);
    }

    public IPath getFullIncludePath() {
        IPath inc = this.getIncludePath();
        if (!this.basePath.isEmpty()) {
            IResource res;
            IPath loc = this.basePath;
            if (!loc.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(loc)) != null) {
                loc = res.getLocation();
            }
            IPath p = loc.append(inc);
            return p;
        }
        IPath p = inc;
        if (!p.isAbsolute()) {
            IPath resPath = this.getPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resPath);
            if (res != null) {
                IPath location;
                if (res.getType() == 1) {
                    res = res.getParent();
                }
                if ((location = res.getLocation()) != null) {
                    p = location.append(p);
                }
            }
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.isSystemInclude) {
            sb.append(" isSystemInclude:").append(this.isSystemInclude);
        }
        if (this.includePath != null && !this.includePath.isEmpty()) {
            sb.append(" includePath:").append(this.includePath);
        }
        return sb.toString();
    }
}

