/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GCCScannerInfoConsoleParser
implements IScannerInfoConsoleParser {
    private IProject fProject = null;
    private IScannerInfoConsoleParserUtility fUtil = null;
    private IScannerInfoCollector fCollector = null;

    public void startup(IProject project, IScannerInfoConsoleParserUtility util, IScannerInfoCollector collector) {
        this.fProject = project;
        this.fUtil = util;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        ArrayList<String> allTokens;
        boolean rc = false;
        TraceUtil.outputTrace("GCCScannerInfoConsoleParser parsing line:", TraceUtil.EOL, line);
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    this.fUtil.changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    return rc;
                }
            }
        }
        if ((allTokens = new ArrayList<String>(Arrays.asList(ScannerConfigUtil.tokenizeStringWithQuotes(line)))).size() <= 1) {
            return false;
        }
        Iterator<String> I = allTokens.iterator();
        String token = I.next().toLowerCase();
        if (token.indexOf("gcc") != -1 || token.indexOf("g++") != -1 || token.indexOf("qcc") != -1) {
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> symbols = new ArrayList<String>();
            ArrayList<String> targetSpecificOptions = new ArrayList<String>();
            rc = true;
            String fileName = null;
            String cashedToken = null;
            while (I.hasNext()) {
                if (cashedToken == null) {
                    token = I.next();
                } else {
                    token = cashedToken;
                    cashedToken = null;
                }
                if (token.length() == 0) continue;
                if (token.startsWith("-D")) {
                    String symbol = token.substring(2);
                    if (symbol.length() == 0) {
                        if (!I.hasNext()) continue;
                        symbol = I.next();
                    }
                    if (symbol.charAt(0) == '-') {
                        cashedToken = symbol;
                        continue;
                    }
                    if (symbols.contains(symbol)) continue;
                    symbols.add(symbol);
                    continue;
                }
                if (token.startsWith("-I")) {
                    String iPath = token.substring(2);
                    if (iPath.length() == 0) {
                        if (!I.hasNext()) continue;
                        iPath = I.next();
                    }
                    if (iPath.charAt(0) == '-') {
                        cashedToken = iPath;
                        continue;
                    }
                    String nPath = this.fUtil.normalizePath(iPath);
                    if (includes.contains(nPath)) continue;
                    includes.add(nPath);
                    continue;
                }
                if (token.equals("-mwin32") || token.equals("-mno-win32") || token.equals("-mno-cygwin") || token.equals("-ansi") || token.equals("-nostdinc") || token.equals("-posix") || token.equals("-pthread")) {
                    if (targetSpecificOptions.contains(token)) continue;
                    targetSpecificOptions.add(token);
                    continue;
                }
                String possibleFileName = token.toLowerCase();
                if (!possibleFileName.startsWith("..") && !possibleFileName.startsWith(".") && !possibleFileName.startsWith("/") && !possibleFileName.endsWith(".c") && !possibleFileName.endsWith(".cpp") && !possibleFileName.endsWith(".cc") && !possibleFileName.endsWith(".cxx") && !possibleFileName.endsWith(".C") && !possibleFileName.endsWith(".CC")) continue;
                fileName = token;
            }
            IProject project = this.fProject;
            IFile file = null;
            List<String> translatedIncludes = includes;
            if (includes.size() > 0) {
                if (fileName != null) {
                    file = this.fUtil.findFile(fileName);
                    if (file != null) {
                        project = file.getProject();
                        translatedIncludes = this.fUtil.translateRelativePaths(file, fileName, includes);
                    }
                } else {
                    String error = MakeMessages.getString("ConsoleParser.Filename_Missing_Error_Message");
                    TraceUtil.outputError(error, line);
                    this.fUtil.generateMarker((IResource)this.fProject, -1, String.valueOf(error) + line, 1, null);
                }
                if (file == null) {
                    translatedIncludes.clear();
                }
            }
            if (translatedIncludes.size() > 0 || symbols.size() > 0) {
                HashMap<Integer, ArrayList<String>> extraInfo = new HashMap<Integer, ArrayList<String>>();
                extraInfo.put(IScannerInfoCollector.TARGET_SPECIFIC_OPTION, targetSpecificOptions);
                this.fCollector.contributeToScannerConfig((IResource)project, translatedIncludes, symbols, extraInfo);
                TraceUtil.outputTrace("Discovered scanner info for file '" + fileName + '\'', "Include paths", includes, translatedIncludes, "Defined symbols", symbols);
            }
        }
        return rc;
    }

    public void shutdown() {
        if (this.fUtil != null) {
            this.fUtil.reportProblems();
        }
    }

    private int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }
}

