/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTUsingDeclaration
extends ASTDeclaration
implements IASTUsingDeclaration {
    private final boolean isTypename;
    private final String mappingName;
    private Offsets offsets = new Offsets();

    public ASTUsingDeclaration(IASTScope scope, boolean isTypeName, String mappingName, int startingOffset, int startingLine, int endingOffset, int endingLine) {
        super(scope);
        this.isTypename = isTypeName;
        this.mappingName = mappingName;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public String usingTypeName() {
        return this.mappingName;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptUsingDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public Iterator getUsingTypes() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }
}

