/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Random;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewManagedProjectWizard
extends NewCProjectWizard {
    protected static final String PREFIX = "MngMakeProjectWizard";
    protected static final String OP_ERROR = "MngMakeProjectWizard.op_error";
    protected static final String WZ_TITLE = "MngMakeProjectWizard.title";
    protected static final String WZ_DESC = "MngMakeProjectWizard.description";
    protected static final String CONF_TITLE = "MngMakeProjectWizard.config.title";
    protected static final String CONF_DESC = "MngMakeProjectWizard.config.desc";
    protected static final String OPTIONS_TITLE = "MngMakeProjectWizard.options.title";
    protected static final String OPTIONS_DESC = "MngMakeProjectWizard.options.desc";
    protected static final String MSG_ADD_NATURE = "MngMakeProjectWizard.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "MngMakeProjectWizard.message.add_builder";
    protected static final String MSG_SAVE = "MngMakeProjectWizard.message.save";
    protected static final String SETTINGS_TITLE = "MngMakeWizardSettings.title";
    protected static final String SETTINGS_DESC = "MngMakeWizardSettings.description";
    protected CProjectPlatformPage targetConfigurationPage;
    protected NewManagedProjectOptionPage optionPage;

    public NewManagedProjectWizard() {
        this(ManagedBuilderUIMessages.getResourceString(WZ_TITLE), ManagedBuilderUIMessages.getResourceString(WZ_DESC));
    }

    public NewManagedProjectWizard(String title, String description) {
        super(title, description);
    }

    public void addPages() {
        super.addPages();
        this.targetConfigurationPage = new CProjectPlatformPage(PREFIX, this);
        this.targetConfigurationPage.setTitle(ManagedBuilderUIMessages.getResourceString(CONF_TITLE));
        this.targetConfigurationPage.setDescription(ManagedBuilderUIMessages.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.targetConfigurationPage);
        this.optionPage = new NewManagedProjectOptionPage(PREFIX, this);
        this.optionPage.setTitle(ManagedBuilderUIMessages.getResourceString(OPTIONS_TITLE));
        this.optionPage.setDescription(ManagedBuilderUIMessages.getResourceString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IWizardPage[] pages = this.getPages();
        if (pages != null && pages.length == 3) {
            WorkbenchHelp.setHelp((Control)pages[0].getControl(), (String)"org.eclipse.cdt.ui.new_proj_wiz_m_name");
            NewManagedProjectOptionPage optionPage = (NewManagedProjectOptionPage)pages[2];
            optionPage.setupHelpContextIds();
        }
    }

    public void updateTargetProperties() {
        this.optionPage.updateTargetProperties();
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        block11: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            try {
                monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_ADD_NATURE));
                ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_ADD_BUILDER));
                ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException e) {
                ManagedBuilderUIPlugin.log(e);
            }
            ITarget newTarget = null;
            try {
                ManagedBuildManager.createBuildInfo((IResource)this.newProject);
                ITarget parent = this.targetConfigurationPage.getSelectedTarget();
                newTarget = ManagedBuildManager.createTarget((IResource)this.newProject, (ITarget)parent);
                if (newTarget == null) break block11;
                ICDescriptor desc = null;
                try {
                    desc = CCorePlugin.getDefault().getCProjectDescription(this.newProject, true);
                    desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                    desc.create("org.eclipse.cdt.core.BinaryParser", newTarget.getBinaryParserId());
                }
                catch (CoreException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
                newTarget.setArtifactName(this.getBuildGoalName());
                IConfiguration[] selectedConfigs = this.targetConfigurationPage.getSelectedConfigurations();
                Random r = new Random();
                r.setSeed(System.currentTimeMillis());
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = r.nextInt();
                    if (id < 0) {
                        id *= -1;
                    }
                    newTarget.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
                    ++i;
                }
                IConfiguration[] newConfigs = newTarget.getConfigurations();
                if (newConfigs.length > 0) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, (IConfiguration)newConfigs[0]);
                }
                ManagedBuildManager.setSelectedTarget((IProject)this.newProject, (ITarget)newTarget);
                ManagedBuildManager.setNewProjectVersion((IProject)this.newProject);
            }
            catch (BuildException e) {
                ManagedBuilderUIPlugin.log(e);
            }
        }
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        monitor.subTask(ManagedBuilderUIMessages.getResourceString(MSG_SAVE));
        ManagedBuildManager.saveBuildInfo((IProject)this.newProject, (boolean)true);
        monitor.done();
    }

    private String getBuildGoalName() {
        String name = new String();
        String[] tokens = this.newProject.getName().split("\\s");
        int index = 0;
        while (index < tokens.length) {
            name = String.valueOf(name) + tokens[index];
            ++index;
        }
        return name;
    }

    protected void doRunPrologue(IProgressMonitor monitor) {
    }

    protected void doRunEpilogue(IProgressMonitor monitor) {
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)this.newProject);
        if (initResult.getCode() != 0) {
            ManagedBuilderUIPlugin.log(initResult);
        }
    }

    public String getProjectID() {
        return ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID;
    }

    public ITarget getSelectedTarget() {
        return this.targetConfigurationPage.getSelectedTarget();
    }
}

