/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathInfo
implements IDiscoveredPathManager.IDiscoveredPathInfo {
    private final IProject project;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap discoveredSymbols;
    private List activePaths;
    private Map activeSymbols;

    public DiscoveredPathInfo(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Map getSymbols() {
        if (this.activeSymbols == null) {
            this.createSymbolsMap();
        }
        Map dSymbols = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        return dSymbols;
    }

    public synchronized IPath[] getIncludePaths() {
        if (this.activePaths == null) {
            this.createPathLists();
        }
        return this.activePaths.toArray(new IPath[this.activePaths.size()]);
    }

    public LinkedHashMap getIncludeMap() {
        if (this.discoveredPaths == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredPaths);
    }

    public synchronized void setIncludeMap(LinkedHashMap paths) {
        this.discoveredPaths = new LinkedHashMap(paths);
        this.activePaths = null;
    }

    private void createPathLists() {
        List aPaths = this.getActivePathList();
        aPaths.clear();
        Iterator i = this.discoveredPaths.keySet().iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            Boolean removed = (Boolean)this.discoveredPaths.get(path);
            if (removed != null && removed.booleanValue()) continue;
            aPaths.add(new Path(path));
        }
    }

    public LinkedHashMap getSymbolMap() {
        if (this.discoveredSymbols == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredSymbols);
    }

    public synchronized void setSymbolMap(LinkedHashMap symbols) {
        this.discoveredSymbols = new LinkedHashMap(symbols);
        this.activeSymbols = null;
    }

    private void createSymbolsMap() {
        Map aSymbols = this.getActiveSymbolsMap();
        aSymbols.clear();
        aSymbols.putAll(ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols));
    }

    private List getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList();
        }
        return this.activePaths;
    }

    private Map getActiveSymbolsMap() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new HashMap();
        }
        return this.activeSymbols;
    }
}

