/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.Iterator;
import java.util.List;

public class TraceUtil {
    public static final String EOL = System.getProperty("line.separator");
    public static boolean SCANNER_CONFIG = false;

    public static boolean isTracing() {
        return SCANNER_CONFIG;
    }

    public static void outputTrace(String prefix, String msg, String postfix) {
        if (TraceUtil.isTracing()) {
            System.out.println();
            System.out.println(String.valueOf(prefix) + ' ' + msg + ' ' + postfix);
        }
    }

    public static void outputTrace(String title, String subtitle1, List item1, List item1new, String subtitle2, List item2) {
        if (TraceUtil.isTracing()) {
            System.out.println();
            System.out.println(title);
            System.out.println("  " + subtitle1 + " (" + item1.size() + "):");
            int count = 0;
            Iterator i = item1.iterator();
            Iterator j = item1new.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + (String)i.next() + (j.hasNext() ? "' -> '" + (String)j.next() : "") + '\'');
            }
            System.out.println("  " + subtitle2 + " (" + item2.size() + "):");
            count = 0;
            i = item2.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + (String)i.next() + '\'');
            }
        }
    }

    public static void outputError(String string, String line) {
        if (TraceUtil.isTracing()) {
            System.out.println();
            System.out.println("Error: " + string + line);
        }
    }
}

