/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElement;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElementLabelProvider;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElementSorter;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;

public class DiscoveredPathContainerPage
extends WizardPage
implements ICPathContainerPage {
    private static final String PREFIX = "DiscoveredScannerConfigurationContainerPage";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String UP = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.up.label";
    private static final String DOWN = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.down.label";
    private static final String DISABLE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.disable.label";
    private static final String ENABLE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.enable.label";
    private static final String DELETE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String CONTAINER_LABEL = "DiscoveredScannerConfigurationContainerPage.title";
    private static final String CONTAINER_DESCRIPTION = "DiscoveredScannerConfigurationContainerPage.description";
    private static final String CONTAINER_LIST_LABEL = "DiscoveredScannerConfigurationContainerPage.list.title";
    private final int IDX_UP = 0;
    private final int IDX_DOWN = 1;
    private final int IDX_ENABLE = 2;
    private final int IDX_DISABLE = 3;
    private final int IDX_DELETE = 5;
    private static final int DISC_UP = 0;
    private static final int DISC_DOWN = 1;
    private static final int DO_DISABLE = 0;
    private static final int DO_ENABLE = 1;
    private ICProject fCProject;
    private IContainerEntry fPathEntry;
    private TreeListDialogField fDiscoveredContainerList;
    private boolean dirty;
    private CopyTextAction copyTextAction;
    private HandlerSubmission submission;

    public DiscoveredPathContainerPage() {
        super(PREFIX);
        this.setTitle(MakeUIPlugin.getResourceString(CONTAINER_LABEL));
        this.setDescription(MakeUIPlugin.getResourceString(CONTAINER_DESCRIPTION));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        String[] stringArray = new String[6];
        stringArray[0] = MakeUIPlugin.getResourceString(UP);
        stringArray[1] = MakeUIPlugin.getResourceString(DOWN);
        stringArray[2] = MakeUIPlugin.getResourceString(ENABLE);
        stringArray[3] = MakeUIPlugin.getResourceString(DISABLE);
        stringArray[5] = MakeUIPlugin.getResourceString(DELETE);
        String[] buttonLabels = stringArray;
        DiscoveredContainerAdapter adapter = new DiscoveredContainerAdapter();
        this.fDiscoveredContainerList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new DiscoveredElementLabelProvider());
        this.fDiscoveredContainerList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fDiscoveredContainerList.setLabelText(MakeUIPlugin.getResourceString(CONTAINER_LIST_LABEL));
        this.fDiscoveredContainerList.setViewerSorter((ViewerSorter)new DiscoveredElementSorter());
        this.dirty = false;
    }

    public void dispose() {
        this.deregisterActionHandlers();
        super.dispose();
    }

    public void initialize(ICProject project, IPathEntry[] currentEntries) {
        this.fCProject = project;
    }

    public boolean finish() {
        if (!this.dirty) {
            return true;
        }
        try {
            Object[] cChildren;
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fCProject.getProject());
            LinkedHashMap<String, Boolean> includes = new LinkedHashMap<String, Boolean>();
            LinkedHashMap symbols = new LinkedHashMap();
            DiscoveredElement container = (DiscoveredElement)this.fDiscoveredContainerList.getElement(0);
            if (container != null && container.getEntryKind() == 1 && (cChildren = container.getChildren()) != null) {
                int i = 0;
                while (i < cChildren.length) {
                    DiscoveredElement group = (DiscoveredElement)cChildren[i];
                    switch (group.getEntryKind()) {
                        case 4: {
                            Object[] gChildren = group.getChildren();
                            if (gChildren == null) break;
                            int j = 0;
                            while (j < gChildren.length) {
                                DiscoveredElement include = (DiscoveredElement)gChildren[j];
                                includes.put(include.getEntry(), include.isRemoved());
                                ++j;
                            }
                            break;
                        }
                        case 5: {
                            Object[] gChildren = group.getChildren();
                            if (gChildren == null) break;
                            int j = 0;
                            while (j < gChildren.length) {
                                DiscoveredElement symbol = (DiscoveredElement)gChildren[j];
                                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(symbols, (String)symbol.getEntry(), (!symbol.isRemoved() ? 1 : 0) != 0);
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
            info.setIncludeMap(includes);
            info.setSymbolMap(symbols);
            try {
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(info);
                return true;
            }
            catch (CoreException e) {
                MakeCorePlugin.log((Throwable)e);
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log((Throwable)e);
        }
        return false;
    }

    public IPathEntry[] getContainerEntries() {
        return new IPathEntry[]{this.fPathEntry};
    }

    public void setSelection(IPathEntry containerEntry) {
        if (containerEntry != null) {
            if (containerEntry.getEntryKind() == 5) {
                this.fPathEntry = (IContainerEntry)containerEntry;
            }
        } else {
            this.fPathEntry = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        }
        if (this.fPathEntry != null) {
            DiscoveredElement element = this.populateDiscoveredElements(this.fPathEntry);
            ArrayList<DiscoveredElement> elements = new ArrayList<DiscoveredElement>();
            elements.add(element);
            this.fDiscoveredContainerList.addElements(elements);
        }
    }

    private DiscoveredElement populateDiscoveredElements(IContainerEntry pathEntry) {
        DiscoveredElement container = null;
        try {
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fCProject.getProject());
            container = DiscoveredElement.createNew(null, this.fCProject.getProject(), null, 1, false, false);
            try {
                IPathEntryContainer peContainer = CoreModel.getPathEntryContainer((IPath)pathEntry.getPath(), (ICProject)this.fCProject);
                if (peContainer != null) {
                    container.setEntry(peContainer.getDescription());
                }
                LinkedHashMap paths = info.getIncludeMap();
                Iterator i = paths.keySet().iterator();
                while (i.hasNext()) {
                    String include = (String)i.next();
                    Boolean removed = (Boolean)paths.get(include);
                    removed = removed == null ? Boolean.FALSE : removed;
                    DiscoveredElement.createNew(container, this.fCProject.getProject(), include, 2, removed, false);
                }
                LinkedHashMap symbols = info.getSymbolMap();
                Iterator i2 = symbols.keySet().iterator();
                while (i2.hasNext()) {
                    String value;
                    String symbol = (String)i2.next();
                    SymbolEntry se = (SymbolEntry)symbols.get(symbol);
                    Iterator j = se.getActiveRaw().iterator();
                    while (j.hasNext()) {
                        value = (String)j.next();
                        DiscoveredElement.createNew(container, this.fCProject.getProject(), value, 3, false, false);
                    }
                    j = se.getRemovedRaw().iterator();
                    while (j.hasNext()) {
                        value = (String)j.next();
                        DiscoveredElement.createNew(container, this.fCProject.getProject(), value, 3, true, false);
                    }
                }
            }
            catch (CModelException e) {
                MakeUIPlugin.log(e.getStatus());
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.log(e);
        }
        return container;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fDiscoveredContainerList}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fDiscoveredContainerList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fDiscoveredContainerList.setButtonsMinWidth(buttonBarWidth);
        this.fDiscoveredContainerList.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof DiscoveredElement) {
                    DiscoveredElement elem = (DiscoveredElement)element;
                    switch (elem.getEntryKind()) {
                        case 4: 
                        case 5: {
                            return elem.getChildren().length != 0;
                        }
                    }
                }
                return true;
            }
        });
        this.setControl((Control)composite);
        this.fDiscoveredContainerList.selectFirstElement();
        Shell shell = this.fDiscoveredContainerList.getTreeViewer().getControl().getShell();
        this.copyTextAction = new CopyTextAction(shell);
        this.hookContextMenu();
        this.registerActionHandler(shell, (IAction)this.copyTextAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DiscoveredPathContainerPage.this.copyTextAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fDiscoveredContainerList.getTreeViewer().getControl());
        this.fDiscoveredContainerList.getTreeViewer().getControl().setMenu(menu);
    }

    private void registerActionHandler(Shell shell, IAction action) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        this.submission = new HandlerSubmission(null, shell, null, "org.eclipse.ui.edit.copy", (IHandler)new ActionHandler(action), Priority.MEDIUM);
        commandSupport.addHandlerSubmission(this.submission);
        contextSupport.registerShell(shell, 0);
    }

    private void deregisterActionHandlers() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchContextSupport contextSupport = workbench.getContextSupport();
        IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
        commandSupport.removeHandlerSubmission(this.submission);
        contextSupport.unregisterShell(this.fDiscoveredContainerList.getTreeViewer().getControl().getShell());
    }

    private void containerPageCustomButtonPressed(TreeListDialogField field, int index) {
        switch (index) {
            case 0: {
                this.dirty |= this.moveUp();
                break;
            }
            case 1: {
                this.dirty |= this.moveDown();
                break;
            }
            case 3: {
                this.dirty |= this.enableDisableEntry(0);
                break;
            }
            case 2: {
                this.dirty |= this.enableDisableEntry(1);
                break;
            }
            case 5: {
                this.dirty |= this.deleteEntry();
            }
        }
        if (this.dirty) {
            this.fDiscoveredContainerList.refresh();
            this.fDiscoveredContainerList.setFocus();
        }
    }

    private boolean moveUp() {
        boolean rc = false;
        List selElements = this.fDiscoveredContainerList.getSelectedElements();
        Iterator i = selElements.iterator();
        while (i.hasNext()) {
            DiscoveredElement elem = (DiscoveredElement)i.next();
            DiscoveredElement parent = elem.getParent();
            Object[] children = parent.getChildren();
            int j = 0;
            while (j < children.length) {
                int prevIndex;
                DiscoveredElement child = (DiscoveredElement)children[j];
                if (elem.equals(child) && (prevIndex = j - 1) >= 0) {
                    children[j] = children[prevIndex];
                    children[prevIndex] = elem;
                    rc = true;
                    break;
                }
                ++j;
            }
            parent.setChildren(children);
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(selElements));
        return rc;
    }

    private boolean moveDown() {
        boolean rc = false;
        List selElements = this.fDiscoveredContainerList.getSelectedElements();
        ArrayList revSelElements = new ArrayList(selElements);
        Collections.reverse(revSelElements);
        Iterator i = revSelElements.iterator();
        while (i.hasNext()) {
            DiscoveredElement elem = (DiscoveredElement)i.next();
            DiscoveredElement parent = elem.getParent();
            Object[] children = parent.getChildren();
            int j = children.length - 1;
            while (j >= 0) {
                int prevIndex;
                DiscoveredElement child = (DiscoveredElement)children[j];
                if (elem.equals(child) && (prevIndex = j + 1) < children.length) {
                    children[j] = children[prevIndex];
                    children[prevIndex] = elem;
                    rc = true;
                    break;
                }
                --j;
            }
            parent.setChildren(children);
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(selElements));
        return rc;
    }

    private boolean enableDisableEntry(int action) {
        boolean rc = false;
        boolean remove = action == 0;
        List selElements = this.fDiscoveredContainerList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            DiscoveredElement elem = (DiscoveredElement)selElements.get(i);
            switch (elem.getEntryKind()) {
                case 2: 
                case 3: {
                    elem.setRemoved(remove);
                    rc = true;
                }
            }
            --i;
        }
        return rc;
    }

    private boolean deleteEntry() {
        boolean rc = false;
        ArrayList<Object> newSelection = new ArrayList<Object>();
        List selElements = this.fDiscoveredContainerList.getSelectedElements();
        int i = 0;
        while (i < selElements.size()) {
            DiscoveredElement parent;
            DiscoveredElement elem = (DiscoveredElement)selElements.get(i);
            if (elem.getEntryKind() != 1 && (parent = elem.getParent()) != null) {
                Object[] children = parent.getChildren();
                if (elem.delete()) {
                    switch (elem.getEntryKind()) {
                        case 4: {
                            ScannerInfoCollector.getInstance().deleteAllPaths(this.fCProject.getProject());
                            break;
                        }
                        case 5: {
                            ScannerInfoCollector.getInstance().deleteAllSymbols(this.fCProject.getProject());
                            break;
                        }
                        case 2: {
                            ScannerInfoCollector.getInstance().deletePath(this.fCProject.getProject(), elem.getEntry());
                            break;
                        }
                        case 3: {
                            ScannerInfoCollector.getInstance().deleteSymbol(this.fCProject.getProject(), elem.getEntry());
                        }
                    }
                    rc = true;
                    int j = 0;
                    while (j < children.length) {
                        DiscoveredElement child = (DiscoveredElement)children[j];
                        if (elem.equals(child)) {
                            newSelection.clear();
                            if (j + 1 < children.length) {
                                newSelection.add(children[j + 1]);
                                break;
                            }
                            if (j - 1 >= 0) {
                                newSelection.add(children[j - 1]);
                                break;
                            }
                            newSelection.add(parent);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(newSelection));
        return rc;
    }

    private void containerPageSelectionChanged(TreeListDialogField field) {
        List selElements = field.getSelectedElements();
        this.fDiscoveredContainerList.enableButton(0, this.canMoveUpDown(selElements, 0));
        this.fDiscoveredContainerList.enableButton(1, this.canMoveUpDown(selElements, 1));
        this.fDiscoveredContainerList.enableButton(3, this.canRemoveRestore(selElements));
        this.fDiscoveredContainerList.enableButton(2, this.canRemoveRestore(selElements));
        this.fDiscoveredContainerList.enableButton(5, this.canDelete(selElements));
    }

    private boolean canMoveUpDown(List selElements, int direction) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            int borderElementIndex;
            DiscoveredElement elem = (DiscoveredElement)selElements.get(i);
            switch (elem.getEntryKind()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return false;
                }
            }
            DiscoveredElement parent = elem.getParent();
            Object borderElem = null;
            int n = borderElementIndex = direction == 0 ? 0 : parent.getChildren().length - 1;
            if (parent.getEntryKind() == 4) {
                borderElem = (DiscoveredElement)parent.getChildren()[borderElementIndex];
            }
            if (borderElem != null && borderElem.equals(elem)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canRemoveRestore(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            DiscoveredElement elem = (DiscoveredElement)selElements.get(i);
            switch (elem.getEntryKind()) {
                case 1: 
                case 4: 
                case 5: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean canDelete(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            DiscoveredElement elem = (DiscoveredElement)selElements.get(i);
            if (elem.getEntryKind() == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class DiscoveredContainerAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        DiscoveredContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            DiscoveredPathContainerPage.this.containerPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            if (DiscoveredPathContainerPage.this.copyTextAction != null) {
                DiscoveredPathContainerPage.this.copyTextAction.canBeApplied(field.getSelectedElements());
            }
            DiscoveredPathContainerPage.this.containerPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof DiscoveredElement) {
                DiscoveredElement elem = (DiscoveredElement)element;
                return elem.getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof DiscoveredElement) {
                DiscoveredElement elem = (DiscoveredElement)element;
                return elem.getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            if (element instanceof DiscoveredElement) {
                DiscoveredElement elem = (DiscoveredElement)element;
                return elem.hasChildren();
            }
            return false;
        }
    }

    public class CopyTextAction
    extends Action {
        static final String ACTION_ID = "org.eclipse.ui.edit.copy";
        private Shell shell;
        private Clipboard clipboard;
        private String discoveredEntry = null;

        public CopyTextAction(Shell shell) {
            super(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.title"));
            this.setDescription(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.description"));
            this.setToolTipText(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.tooltip"));
            this.setActionDefinitionId(ACTION_ID);
            this.clipboard = new Clipboard(shell.getDisplay());
            this.shell = shell;
        }

        boolean canBeApplied(List selElements) {
            boolean rc = false;
            if (selElements != null && selElements.size() == 1) {
                DiscoveredElement elem = (DiscoveredElement)selElements.get(0);
                switch (elem.getEntryKind()) {
                    case 2: 
                    case 3: {
                        this.discoveredEntry = elem.getEntry();
                        rc = true;
                    }
                }
            }
            this.setEnabled(rc);
            return rc;
        }

        public void run() {
            if (this.discoveredEntry != null) {
                this.clipboard.setContents(new Object[]{this.discoveredEntry}, new Transfer[]{TextTransfer.getInstance()});
                this.discoveredEntry = null;
            }
        }
    }
}

