/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScannerConfigOptionsDialog
extends Dialog {
    private static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String DIALOG_TITLE = "ScannerConfigOptionsDialog.title";
    private static final String SI_BUILD_PARSER_GROUP = "ScannerConfigOptionsDialog.siBuilder.parser.group_label";
    private static final String ENABLE_SI_BUILD_PARSER = "ScannerConfigOptionsDialog.siBuilder.parser.enable.label";
    private static final String SI_BUILD_PARSER_LABEL = "ScannerConfigOptionsDialog.siBuilder.parser.label";
    private static final String SI_PROVIDER_CMD_GROUP = "ScannerConfigOptionsDialog.siProvider.cmd.group_label";
    private static final String ENABLE_SI_PROVIDER_COMMAND = "ScannerConfigOptionsDialog.siProvider.cmd.enable.label";
    private static final String SI_PROVIDER_CMD_USE_DEFAULT = "ScannerConfigOptionsDialog.siProvider.cmd.use_default";
    private static final String SI_PROVIDER_CMD_LABEL = "ScannerConfigOptionsDialog.siProvider.cmd.label";
    private static final String SI_PROVIDER_PARSER_LABEL = "ScannerConfigOptionsDialog.siProvider.parser.label";
    private static final String SI_PROVIDER_CMD_ERROR_MESSAGE = "ScannerConfigOptionsDialog.siProvider.cmd.error_message";
    private MessageLine fStatusLine;
    private Button defESIProviderCommandButton;
    private Text esiProviderCommand;
    private Button enableBuilderParserButton;
    private Combo makeBuilderSIParserComboBox;
    private Button enableProviderCommandButton;
    private Combo esiProviderParserComboBox;
    private ICOptionContainer fContainer;
    private Preferences fPrefs;
    private IScannerConfigBuilderInfo fBuildInfo;
    private boolean fInitialized;
    private Map builderParsers = new HashMap();
    private String initialBuilderParserId = null;
    private Map providerParsers = new HashMap();
    private String initialProviderParserId = null;

    ScannerConfigOptionsDialog(ICOptionContainer container) {
        super(null);
        this.fInitialized = false;
        this.fContainer = container;
        this.fPrefs = this.fContainer.getPreferences();
        IScannerConfigBuilderInfo fInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        this.fBuildInfo = new LocalStore(fInfo);
    }

    ScannerConfigOptionsDialog(Shell parentShell, ICOptionContainer container) {
        super(parentShell);
        IScannerConfigBuilderInfo fInfo;
        this.fInitialized = true;
        this.fContainer = container;
        IProject project = this.fContainer.getProject();
        this.fPrefs = this.fContainer.getPreferences();
        if (project != null) {
            try {
                fInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)project, (String)ScannerConfigBuilder.BUILDER_ID);
            }
            catch (CoreException coreException) {
                this.fInitialized = false;
                fInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
            }
        } else {
            fInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        }
        this.retrieveSIConsoleParsers();
        this.initialBuilderParserId = fInfo.getMakeBuilderConsoleParserId();
        this.initialProviderParserId = fInfo.getESIProviderConsoleParserId();
        this.fBuildInfo = new LocalStore(fInfo);
    }

    private void retrieveSIConsoleParsers() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("ScannerInfoConsoleParser");
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String parserId = extensions[i].getUniqueIdentifier();
                String label = extensions[i].getLabel();
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                String commandId = elements[0].getAttribute("commandId");
                if (commandId.equals("makeBuilder") || commandId.equals("all")) {
                    this.builderParsers.put(label, parserId);
                }
                if (commandId.equals("externalScannerInfoProvider") || commandId.equals("all")) {
                    this.providerParsers.put(label, parserId);
                }
                ++i;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(newShell);
    }

    private String getTitle(String title) {
        return MakeUIPlugin.getResourceString(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData gd = new GridData(768);
        this.fStatusLine.setLayoutData(gd);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createBuildOutputParserControls(composite);
        this.createAfterBuildCmdControls(composite);
        this.enableAllControls();
        return composite;
    }

    private void createBuildOutputParserControls(Composite parent) {
        Group bopGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_GROUP), (int)2);
        ((GridLayout)bopGroup.getLayout()).marginHeight = 5;
        ((GridLayout)bopGroup.getLayout()).marginWidth = 5;
        ((GridData)bopGroup.getLayoutData()).verticalAlignment = 4;
        this.enableBuilderParserButton = ControlFactory.createCheckBox((Composite)bopGroup, (String)MakeUIPlugin.getResourceString(ENABLE_SI_BUILD_PARSER));
        ((GridData)this.enableBuilderParserButton.getLayoutData()).horizontalSpan = 2;
        boolean enabledBuilderParser = this.fBuildInfo.isMakeBuilderConsoleParserEnabled();
        this.enableBuilderParserButton.setSelection(enabledBuilderParser);
        this.enableBuilderParserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScannerConfigOptionsDialog.this.makeBuilderSIParserComboBox.setEnabled(ScannerConfigOptionsDialog.this.isBuilderParserEnabled());
            }
        });
        Label label = ControlFactory.createLabel((Composite)bopGroup, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.makeBuilderSIParserComboBox = new Combo((Composite)bopGroup, 12);
        Iterator items = this.builderParsers.keySet().iterator();
        while (items.hasNext()) {
            String parser = (String)items.next();
            this.makeBuilderSIParserComboBox.add(parser);
            if (!this.initialBuilderParserId.equals(this.builderParsers.get(parser))) continue;
            this.makeBuilderSIParserComboBox.setText(parser);
        }
        this.makeBuilderSIParserComboBox.setEnabled(enabledBuilderParser);
    }

    private void createAfterBuildCmdControls(Composite parent) {
        Group abcGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_GROUP), (int)2);
        ((GridData)abcGroup.getLayoutData()).horizontalSpan = 2;
        this.enableProviderCommandButton = ControlFactory.createCheckBox((Composite)abcGroup, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROVIDER_COMMAND));
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        boolean enabledProviderCommand = this.fBuildInfo.isESIProviderCommandEnabled();
        this.enableProviderCommandButton.setSelection(enabledProviderCommand);
        this.enableProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScannerConfigOptionsDialog.this.defESIProviderCommandButton.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled());
                ScannerConfigOptionsDialog.this.esiProviderCommand.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled() && !ScannerConfigOptionsDialog.this.useDefaultESIProviderCmd());
                ScannerConfigOptionsDialog.this.esiProviderParserComboBox.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled());
            }
        });
        this.createESIProviderCmdControls((Composite)abcGroup);
        Label label = ControlFactory.createLabel((Composite)abcGroup, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderParserComboBox = new Combo((Composite)abcGroup, 12);
        Iterator items = this.providerParsers.keySet().iterator();
        while (items.hasNext()) {
            String parser = (String)items.next();
            this.esiProviderParserComboBox.add(parser);
            if (!this.initialProviderParserId.equals(this.providerParsers.get(parser))) continue;
            this.esiProviderParserComboBox.setText(parser);
        }
        this.defESIProviderCommandButton.setEnabled(enabledProviderCommand);
        this.esiProviderCommand.setEnabled(enabledProviderCommand && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(enabledProviderCommand);
    }

    private void createESIProviderCmdControls(Composite parent) {
        this.defESIProviderCommandButton = ControlFactory.createCheckBox((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_USE_DEFAULT));
        this.defESIProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScannerConfigOptionsDialog.this.esiProviderCommand.setEnabled(!ScannerConfigOptionsDialog.this.useDefaultESIProviderCmd());
            }
        });
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        Label label = ControlFactory.createLabel((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderCommand = ControlFactory.createTextField((Composite)parent, (int)2052);
        ((GridData)this.esiProviderCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.esiProviderCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        IPath sCommand = this.fBuildInfo.getESIProviderCommand();
        if (sCommand != null) {
            StringBuffer cmd = new StringBuffer(sCommand.toOSString());
            String args = this.fBuildInfo.getESIProviderArguments();
            if (args != null && args.length() > 0) {
                cmd.append(' ');
                cmd.append(args);
            }
            this.esiProviderCommand.setText(cmd.toString());
        }
        if (this.fBuildInfo.isDefaultESIProviderCmd()) {
            this.esiProviderCommand.setEnabled(false);
        }
        this.esiProviderCommand.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ScannerConfigOptionsDialog.this.handleProviderCommandModify();
            }
        });
        this.defESIProviderCommandButton.setSelection(this.fBuildInfo.isDefaultESIProviderCmd());
    }

    protected void handleProviderCommandModify() {
        String newCommand = this.esiProviderCommand.getText().trim();
        if (newCommand.length() == 0) {
            this.fStatusLine.setErrorMessage(this.getTitle(SI_PROVIDER_CMD_ERROR_MESSAGE));
            this.getButton(0).setEnabled(false);
        } else {
            this.fStatusLine.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    private void enableAllControls() {
        this.enableBuilderParserButton.setEnabled(true);
        this.makeBuilderSIParserComboBox.setEnabled(this.isBuilderParserEnabled());
        this.enableProviderCommandButton.setEnabled(true);
        this.defESIProviderCommandButton.setEnabled(this.isProviderCommandEnabled());
        this.esiProviderCommand.setEnabled(this.isProviderCommandEnabled() && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(this.isProviderCommandEnabled());
    }

    private boolean useDefaultESIProviderCmd() {
        return this.defESIProviderCommandButton.getSelection();
    }

    private String getSIProviderCommandLine() {
        return this.esiProviderCommand.getText().trim();
    }

    private boolean isBuilderParserEnabled() {
        return this.enableBuilderParserButton.getSelection();
    }

    private boolean isProviderCommandEnabled() {
        return this.enableProviderCommandButton.getSelection();
    }

    public boolean isScannerConfigDiscoveryEnabled() {
        return this.fBuildInfo.isAutoDiscoveryEnabled();
    }

    public void setScannerConfigDiscoveryEnabled(boolean enabled) {
        try {
            this.fBuildInfo.setAutoDiscoveryEnabled(enabled);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        IProject project = this.fContainer.getProject();
        IScannerConfigBuilderInfo buildInfo = project != null ? MakeCorePlugin.createScannerConfigBuildInfo((IProject)project, (String)ScannerConfigBuilder.BUILDER_ID) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        buildInfo.setAutoDiscoveryEnabled(this.fBuildInfo.isAutoDiscoveryEnabled());
        if (this.fBuildInfo.isAutoDiscoveryEnabled()) {
            buildInfo.setMakeBuilderConsoleParserEnabled(this.fBuildInfo.isMakeBuilderConsoleParserEnabled());
            if (this.fBuildInfo.isMakeBuilderConsoleParserEnabled()) {
                buildInfo.setMakeBuilderConsoleParserId(this.fBuildInfo.getMakeBuilderConsoleParserId());
            }
            buildInfo.setESIProviderCommandEnabled(this.fBuildInfo.isESIProviderCommandEnabled());
            if (this.fBuildInfo.isESIProviderCommandEnabled()) {
                buildInfo.setUseDefaultESIProviderCmd(this.fBuildInfo.isDefaultESIProviderCmd());
                if (!this.fBuildInfo.isDefaultESIProviderCmd()) {
                    buildInfo.setESIProviderCommand(this.fBuildInfo.getESIProviderCommand());
                    buildInfo.setESIProviderArguments(this.fBuildInfo.getESIProviderArguments());
                }
                buildInfo.setESIProviderConsoleParserId(this.fBuildInfo.getESIProviderConsoleParserId());
            }
        }
    }

    private void storeSIProviderCommandLine(IScannerConfigBuilderInfo buildInfo) throws CoreException {
        String esiProviderLine = this.getSIProviderCommandLine();
        int start = 0;
        int end = -1;
        if (esiProviderLine.startsWith("\"")) {
            start = 1;
            end = esiProviderLine.indexOf(34, 1);
        } else {
            end = esiProviderLine.indexOf(32);
        }
        Path path = end == -1 ? new Path(esiProviderLine) : new Path(esiProviderLine.substring(start, end));
        buildInfo.setESIProviderCommand((IPath)path);
        String args = "";
        if (end != -1) {
            args = esiProviderLine.substring(end + 1);
        }
        buildInfo.setESIProviderArguments(args);
    }

    public void performDefaults() {
        IScannerConfigBuilderInfo buildInfo = this.fContainer.getProject() != null ? MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
        this.fBuildInfo = new LocalStore(buildInfo);
    }

    protected void okPressed() {
        try {
            this.fBuildInfo.setAutoDiscoveryEnabled(this.isScannerConfigDiscoveryEnabled());
            this.fBuildInfo.setMakeBuilderConsoleParserEnabled(this.isBuilderParserEnabled());
            this.fBuildInfo.setMakeBuilderConsoleParserId((String)this.builderParsers.get(this.makeBuilderSIParserComboBox.getText()));
            this.fBuildInfo.setESIProviderCommandEnabled(this.isProviderCommandEnabled());
            this.fBuildInfo.setUseDefaultESIProviderCmd(this.useDefaultESIProviderCmd());
            this.storeSIProviderCommandLine(this.fBuildInfo);
            this.fBuildInfo.setESIProviderConsoleParserId((String)this.providerParsers.get(this.esiProviderParserComboBox.getText()));
        }
        catch (CoreException coreException) {}
        super.okPressed();
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    protected class LocalStore
    implements IScannerConfigBuilderInfo {
        private boolean fAutoDiscoveryEnabled;
        private boolean fMakeBuilderConsoleParserEnabled;
        private String fMakeBuilderConsoleParserId;
        private boolean fESIProviderCommandEnabled;
        private boolean fDefaultESIProviderCmd;
        private IPath fESIProviderCommand;
        private String fESIProviderArguments;
        private String fESIProviderConsoleParserId;
        private boolean fSIParserGenerationEnabled;

        public LocalStore(IScannerConfigBuilderInfo info) {
            try {
                this.setAutoDiscoveryEnabled(info.isAutoDiscoveryEnabled());
                this.setMakeBuilderConsoleParserEnabled(info.isMakeBuilderConsoleParserEnabled());
                this.setMakeBuilderConsoleParserId(info.getMakeBuilderConsoleParserId());
                this.setESIProviderCommandEnabled(info.isESIProviderCommandEnabled());
                this.setUseDefaultESIProviderCmd(info.isDefaultESIProviderCmd());
                this.setESIProviderCommand(info.getESIProviderCommand());
                this.setESIProviderArguments(info.getESIProviderArguments());
                this.setESIProviderConsoleParserId(info.getESIProviderConsoleParserId());
                this.setSIProblemGenerationEnabled(info.isSIProblemGenerationEnabled());
            }
            catch (CoreException coreException) {}
        }

        public boolean isAutoDiscoveryEnabled() {
            return this.fAutoDiscoveryEnabled;
        }

        public void setAutoDiscoveryEnabled(boolean enabled) throws CoreException {
            this.fAutoDiscoveryEnabled = enabled;
        }

        public boolean isMakeBuilderConsoleParserEnabled() {
            return this.fMakeBuilderConsoleParserEnabled;
        }

        public void setMakeBuilderConsoleParserEnabled(boolean enabled) throws CoreException {
            this.fMakeBuilderConsoleParserEnabled = enabled;
        }

        public String getMakeBuilderConsoleParserId() {
            return this.fMakeBuilderConsoleParserId;
        }

        public void setMakeBuilderConsoleParserId(String parserId) throws CoreException {
            this.fMakeBuilderConsoleParserId = new String(parserId);
        }

        public boolean isESIProviderCommandEnabled() {
            return this.fESIProviderCommandEnabled;
        }

        public void setESIProviderCommandEnabled(boolean enabled) throws CoreException {
            this.fESIProviderCommandEnabled = enabled;
        }

        public boolean isDefaultESIProviderCmd() {
            return this.fDefaultESIProviderCmd;
        }

        public void setUseDefaultESIProviderCmd(boolean on) throws CoreException {
            this.fDefaultESIProviderCmd = on;
        }

        public IPath getESIProviderCommand() {
            return this.fESIProviderCommand;
        }

        public void setESIProviderCommand(IPath command) throws CoreException {
            this.fESIProviderCommand = new Path(command.toString());
        }

        public String getESIProviderArguments() {
            return this.fESIProviderArguments;
        }

        public void setESIProviderArguments(String args) throws CoreException {
            this.fESIProviderArguments = new String(args);
        }

        public String getESIProviderConsoleParserId() {
            return this.fESIProviderConsoleParserId;
        }

        public void setESIProviderConsoleParserId(String parserId) throws CoreException {
            this.fESIProviderConsoleParserId = new String(parserId);
        }

        public boolean isSIProblemGenerationEnabled() {
            return this.fSIParserGenerationEnabled;
        }

        public void setSIProblemGenerationEnabled(boolean enabled) throws CoreException {
            this.fSIParserGenerationEnabled = enabled;
        }
    }
}

