/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParserUtil {
    private static IParserLogService parserLogService = new ParserLogService(IDebugLogConstants.PARSER);
    private static IParserLogService scannerLogService = new ParserLogService(IDebugLogConstants.SCANNER);

    public static IParserLogService getParserLogService() {
        return parserLogService;
    }

    public static IParserLogService getScannerLogService() {
        return scannerLogService;
    }

    public static CodeReader createReader(String finalPath, Iterator workingCopies) {
        block7: {
            try {
                CodeReader codeReader;
                block8: {
                    char[] buffer;
                    IResource resultingResource = ParserUtil.getResourceForFilename(finalPath);
                    if (resultingResource == null || resultingResource.getType() != 1) break block7;
                    if (workingCopies.hasNext() && (buffer = ParserUtil.findWorkingCopy(resultingResource, workingCopies)) != null) {
                        return new CodeReader(finalPath, buffer);
                    }
                    InputStream in = null;
                    try {
                        in = ((IFile)resultingResource).getContents();
                        codeReader = new CodeReader(finalPath, in);
                        Object var4_5 = null;
                        if (in == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return codeReader;
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        return InternalParserUtil.createFileReader((String)finalPath);
    }

    public static IResource getResourceForFilename(String finalPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        Path path = new Path(finalPath);
        if (workspace.getRoot().getLocation().isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(workspace.getRoot().getLocation().segmentCount());
        }
        IResource resultingResource = workspace.getRoot().findMember((IPath)path);
        return resultingResource;
    }

    protected static char[] findWorkingCopy(IResource resultingResource, Iterator workingCopies) {
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Attempting to find the working copy for " + resultingResource.getName());
        }
        while (workingCopies.hasNext()) {
            IWorkingCopy copy;
            Object next = workingCopies.next();
            if (!(next instanceof IWorkingCopy) || !(copy = (IWorkingCopy)next).getResource().equals((Object)resultingResource)) continue;
            if (parserLogService.isTracing()) {
                parserLogService.traceLog("Working copy found!!");
            }
            return copy.getContents();
        }
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Working copy not found.");
        }
        return null;
    }
}

