/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Set;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.CompleteParser;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class ContextualParser
extends CompleteParser {
    protected IASTScope contextualScope;
    protected IASTCompletionNode.CompletionKind completionKind;
    protected IASTNode context;
    protected IToken finalToken;
    protected Set keywordSet;
    protected String functionOrConstructorName = "";
    private String currentFunctionName = "";
    protected IASTExpression parameterListExpression;

    public ContextualParser(IScanner scanner, ISourceElementRequestor callback, ParserLanguage language, IParserLogService log, IParserExtension extension) {
        super(scanner, callback, language, log, extension);
    }

    protected IASTScope getCompletionScope() {
        return this.contextualScope;
    }

    protected IASTCompletionNode.CompletionKind getCompletionKind() {
        return this.completionKind;
    }

    protected String getCompletionPrefix() {
        return this.finalToken == null ? "" : this.finalToken.getImage();
    }

    protected IASTNode getCompletionContext() {
        return this.context;
    }

    protected void setCompletionContext(IASTNode node) {
        this.context = node;
    }

    protected void setCompletionKind(IASTCompletionNode.CompletionKind kind) {
        this.completionKind = kind;
    }

    protected void setCompletionValues(IASTCompletionNode.CompletionKind kind, Set keywordSet, String prefix) {
        this.setCompletionScope(this.compilationUnit);
        this.keywordSet = keywordSet;
        this.setCompletionKind(kind);
        this.setCompletionContext(null);
        this.setCompletionFunctionName();
        this.setCompletionToken(TokenFactory.createStandAloneToken(1, prefix));
    }

    protected void setCompletionFunctionName() {
        this.functionOrConstructorName = this.currentFunctionName;
    }

    protected void setCompletionKeywords(KeywordSetKey key) {
        this.keywordSet = KeywordSets.getKeywords(key, this.language);
    }

    protected void setCompletionToken(IToken token) {
        this.finalToken = token;
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTNode node, String prefix) throws EndOfFileException {
        this.setCompletionToken(TokenFactory.createStandAloneToken(1, prefix));
        this.setCompletionValues(scope, kind, key, node);
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException {
        this.setCompletionValues(scope, kind, key, null);
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTNode node) throws EndOfFileException {
        this.setCompletionScope(scope);
        this.setCompletionKeywords(key);
        this.setCompletionKind(kind);
        this.setCompletionContext(node);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, IToken first, IToken last, KeywordSetKey key) throws EndOfFileException {
        this.setCompletionScope(scope);
        this.setCompletionKind(kind);
        this.setCompletionKeywords(key);
        ITokenDuple duple = TokenFactory.createTokenDuple(first, last);
        try {
            this.setCompletionContext(this.astFactory.lookupSymbolInContext(scope, duple, null));
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        this.setCompletionFunctionName();
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTExpression firstExpression, IASTExpression.Kind expressionKind) throws EndOfFileException {
        IASTNode node = this.astFactory.expressionToMostPreciseASTNode(scope, firstExpression);
        if (kind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE && !this.validMemberOperation(node, expressionKind)) {
            node = null;
        }
        this.setCompletionValues(scope, kind, key, node);
    }

    private boolean validMemberOperation(IASTNode node, IASTExpression.Kind expressionKind) {
        if (expressionKind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || expressionKind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
            return this.astFactory.validateIndirectMemberOperation(node);
        }
        if (expressionKind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || expressionKind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS) {
            return this.astFactory.validateDirectMemberOperation(node);
        }
        return false;
    }

    protected void setCompletionScope(IASTScope scope) {
        this.contextualScope = scope;
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind) throws EndOfFileException {
        this.setCompletionScope(scope);
        this.setCompletionKind(kind);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, IASTNode context) throws EndOfFileException {
        this.setCompletionScope(scope);
        this.setCompletionKind(kind);
        this.setCompletionContext(context);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected String getCompletionFunctionName() {
        return this.functionOrConstructorName;
    }

    protected void setCurrentFunctionName(String functionName) {
        this.currentFunctionName = functionName;
    }

    protected void handleFunctionBody(IASTScope scope) throws BacktrackException, EndOfFileException {
        if (this.scanner.isOnTopContext()) {
            this.functionBody(scope);
        } else {
            this.skipOverCompoundStatement();
        }
    }

    protected void catchBlockCompoundStatement(IASTScope scope) throws BacktrackException, EndOfFileException {
        if (this.scanner.isOnTopContext()) {
            this.compoundStatement(scope, true);
        } else {
            this.skipOverCompoundStatement();
        }
    }

    protected void setCompletionValuesNoContext(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException {
        this.setCompletionScope(scope);
        this.setCompletionKeywords(key);
        this.setCompletionKind(kind);
        this.checkEndOfFile();
    }

    protected void setParameterListExpression(IASTExpression assignmentExpression) {
        this.parameterListExpression = assignmentExpression;
    }

    public final IASTExpression getParameterListExpression() {
        return this.parameterListExpression;
    }
}

