/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public abstract class ASTSymbol
extends ASTSymbolOwner
implements ISymbolOwner,
IASTDeclaration {
    public ASTSymbol(ISymbol symbol) {
        super(symbol);
    }

    public IASTScope getOwnerScope() {
        if (this.symbol.getContainingSymbol() != null) {
            return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
        }
        return null;
    }

    public IContainerSymbol getLookupQualificationSymbol() throws IASTNode.LookupError {
        ISymbol sym = this.getSymbol();
        IContainerSymbol result = null;
        ParserSymbolTable.TypeInfoProvider provider = sym.getSymbolTable().getTypeInfoProvider();
        TypeInfo info = null;
        try {
            info = sym.getTypeInfo().getFinalType(provider);
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            throw new IASTNode.LookupError();
        }
        if (info.isType(TypeInfo.t_type) && info.getTypeSymbol() != null && info.getTypeSymbol() instanceof IContainerSymbol) {
            result = (IContainerSymbol)info.getTypeSymbol();
        } else if (sym instanceof IContainerSymbol) {
            result = (IContainerSymbol)sym;
        }
        provider.returnTypeInfo(info);
        return result;
    }

    public boolean shouldFilterLookupResult(ISymbol sym) {
        boolean result = false;
        ParserSymbolTable.TypeInfoProvider provider = sym.getSymbolTable().getTypeInfoProvider();
        TypeInfo info = null;
        try {
            info = this.getSymbol().getTypeInfo().getFinalType(provider);
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            return true;
        }
        if (info.checkBit(1024) && !sym.getTypeInfo().checkBit(1024)) {
            result = true;
        }
        if (info.checkBit(2048) && !sym.getTypeInfo().checkBit(2048)) {
            result = true;
        }
        provider.returnTypeInfo(info);
        return result;
    }
}

