/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTTypedefDeclaration
extends ASTDeclaration
implements IASTTypedefDeclaration {
    protected static final ASTNotImplementedException NOT_IMPLEMENTED = new ASTNotImplementedException();
    private final String name;
    private final IASTAbstractDeclaration mapping;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTQualifiedNamedElement qualifiedName;

    public ASTTypedefDeclaration(IASTScope scope, String name, IASTAbstractDeclaration mapping, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine) {
        super(scope);
        this.name = name;
        this.mapping = mapping;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(scope, name);
    }

    public String getName() {
        return this.name;
    }

    public IASTAbstractDeclaration getAbstractDeclarator() {
        return this.mapping;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptTypedefDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public IASTTypeSpecifier getFinalTypeSpecifier() throws ASTNotImplementedException {
        throw NOT_IMPLEMENTED;
    }
}

