/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.LibraryRefContainer;
import org.eclipse.cdt.ui.CElementContentProvider;

public class CViewContentProvider
extends CElementContentProvider {
    public CViewContentProvider() {
    }

    public CViewContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
    }

    public Object[] getChildren(Object element) {
        Object[] objs = super.getChildren(element);
        Object[] extras = null;
        try {
            if (element instanceof ICProject) {
                extras = this.getProjectChildren((ICProject)element);
            } else if (element instanceof IBinaryContainer) {
                extras = this.getExecutables((IBinaryContainer)element);
            } else if (element instanceof IArchiveContainer) {
                extras = this.getArchives((IArchiveContainer)element);
            } else if (element instanceof LibraryRefContainer) {
                extras = ((LibraryRefContainer)element).getChildren(element);
            } else if (element instanceof IncludeRefContainer) {
                extras = ((IncludeRefContainer)element).getChildren(element);
            }
        }
        catch (CModelException cModelException) {
            extras = null;
        }
        if (extras != null && extras.length > 0) {
            objs = BaseCElementContentProvider.concatenate(objs, extras);
        }
        return objs;
    }

    private Object[] getProjectChildren(ICProject cproject) throws CModelException {
        IncludeRefContainer incRefCont;
        Object[] incRefs;
        LibraryRefContainer libRefCont;
        Object[] libRefs;
        IBinaryContainer bin;
        Object[] extras = null;
        IArchiveContainer archive = cproject.getArchiveContainer();
        if (this.getArchives(archive).length > 0) {
            extras = new Object[]{archive};
        }
        if (this.getExecutables(bin = cproject.getBinaryContainer()).length > 0) {
            Object[] o = new Object[]{bin};
            extras = extras != null && extras.length > 0 ? BaseCElementContentProvider.concatenate(extras, o) : o;
        }
        if ((libRefs = (libRefCont = new LibraryRefContainer(cproject)).getChildren(cproject)) != null && libRefs.length > 0) {
            Object[] o = new Object[]{libRefCont};
            extras = extras != null && extras.length > 0 ? BaseCElementContentProvider.concatenate(extras, o) : o;
        }
        if ((incRefs = (incRefCont = new IncludeRefContainer(cproject)).getChildren(cproject)) != null && incRefs.length > 0) {
            Object[] o = new Object[]{incRefCont};
            extras = extras != null && extras.length > 0 ? BaseCElementContentProvider.concatenate(extras, o) : o;
        }
        return extras;
    }

    public Object internalGetParent(Object element) {
        Object parent = super.internalGetParent(element);
        if (element instanceof IIncludeReference) {
            if (parent instanceof ICProject) {
                parent = new IncludeRefContainer((ICProject)parent);
            }
        } else if (element instanceof IncludeRefContainer) {
            parent = ((IncludeRefContainer)element).getCProject();
        }
        if (element instanceof ILibraryReference) {
            if (parent instanceof ICProject) {
                parent = new LibraryRefContainer((ICProject)parent);
            }
        } else if (element instanceof LibraryRefContainer) {
            parent = ((LibraryRefContainer)element).getCProject();
        }
        return parent;
    }
}

