/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchTableContentProvider;
import org.eclipse.cdt.internal.ui.search.CountLabelProvider;
import org.eclipse.cdt.internal.ui.search.ElementNameSorter;
import org.eclipse.cdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.ParentNameSorter;
import org.eclipse.cdt.internal.ui.search.PathNameSorter;
import org.eclipse.cdt.internal.ui.search.actions.GroupAction;
import org.eclipse.cdt.internal.ui.search.actions.SortAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSearchResultPage
extends AbstractTextSearchViewPage {
    private CSearchContentProvider _contentProvider;
    private int _currentSortOrder = 1;
    private int _currentGrouping;
    private SortAction _parentSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.parent_name"), this, 2);
    private SortAction _pathSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.path_name"), this, 3);
    private SortAction _elementNameSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.element_name"), this, 1);
    private GroupAction _groupFileAction;
    private GroupAction _groupFoldersAction;
    private GroupAction _groupProjectAction;
    private GroupAction _groupClassAction;
    private static final String KEY_GROUPING = "org.eclipse.cdt.search.resultpage.grouping";

    public CSearchResultPage() {
        this.initGroupingActions();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.search_view");
    }

    private void initGroupingActions() {
        this._groupProjectAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_project"), CSearchMessages.getString("CSearchResultPage.groupby_project.tooltip"), this, 4);
        this._groupProjectAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERPROJECT);
        this._groupFoldersAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_folder"), CSearchMessages.getString("CSearchResultPage.groupby_folder.tooltip"), this, 3);
        this._groupFoldersAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERFODLER);
        this._groupFileAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_file"), CSearchMessages.getString("CSearchResultPage.groupby_file.tooltip"), this, 2);
        this._groupFileAction.setImageDescriptor(CPluginImages.DESC_OBJS_TUNIT);
        this._groupClassAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_class"), CSearchMessages.getString("CSearchResultPage.groupby_class.tooltip"), this, 1);
        this._groupClassAction.setImageDescriptor(CPluginImages.DESC_OBJS_CLASS);
        try {
            this._currentGrouping = this.getSettings().getInt(KEY_GROUPING);
        }
        catch (NumberFormatException numberFormatException) {
            this._currentGrouping = 4;
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activateEditor) throws PartInitException {
        IEditorPart editor = null;
        Object element = match.getElement();
        if (element instanceof ICElement) {
            ICElement cElement = (ICElement)element;
            try {
                editor = EditorUtility.openInEditor(cElement, false);
            }
            catch (PartInitException partInitException) {
                return;
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        } else if (element instanceof IFile) {
            editor = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)this.getCanonicalFile((IFile)element), (boolean)false);
        } else if (element instanceof BasicSearchMatch) {
            BasicSearchMatch searchMatch = (BasicSearchMatch)element;
            if (searchMatch.resource != null) {
                editor = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)this.getCanonicalFile((IFile)searchMatch.resource), (boolean)false);
                this.showWithMarker(editor, this.getCanonicalFile((IFile)searchMatch.resource), currentOffset, currentLength);
            }
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(currentOffset, currentLength);
        } else if (editor != null && element instanceof IFile) {
            IFile file = (IFile)element;
            this.showWithMarker(editor, this.getCanonicalFile(file), currentOffset, currentLength);
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this._contentProvider != null) {
            this._contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this._contentProvider != null) {
            this._contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setSorter(new ViewerSorter());
        CSearchResultLabelProvider labelProvider = new CSearchResultLabelProvider();
        labelProvider.setOrder(0);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this._contentProvider = new LevelTreeContentProvider((AbstractTreeViewer)viewer, this._currentGrouping);
        viewer.setContentProvider((IContentProvider)this._contentProvider);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new CountLabelProvider(this, (ILabelProvider)new CSearchResultLabelProvider()));
        this._contentProvider = new CSearchTableContentProvider(viewer);
        viewer.setContentProvider((IContentProvider)this._contentProvider);
        this.setSortOrder(this._currentSortOrder);
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException("Search Result Error", (Throwable)e);
        }
    }

    public void setSortOrder(int sortOrder) {
        this._currentSortOrder = sortOrder;
        StructuredViewer viewer = this.getViewer();
        CountLabelProvider lpWrapper = (CountLabelProvider)viewer.getLabelProvider();
        ((CSearchResultLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        if (sortOrder == 1) {
            viewer.setSorter((ViewerSorter)new ElementNameSorter());
        } else if (sortOrder == 3) {
            viewer.setSorter((ViewerSorter)new PathNameSorter());
        } else {
            viewer.setSorter((ViewerSorter)new ParentNameSorter());
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(CSearchMessages.getString("CSearchResultPage.sort"));
        sortMenu.add((IAction)this._elementNameSortAction);
        sortMenu.add((IAction)this._pathSortAction);
        sortMenu.add((IAction)this._parentSortAction);
        this._elementNameSortAction.setChecked(this._currentSortOrder == this._elementNameSortAction.getSortOrder());
        this._pathSortAction.setChecked(this._currentSortOrder == this._pathSortAction.getSortOrder());
        this._parentSortAction.setChecked(this._currentSortOrder == this._parentSortAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupProjectAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupFoldersAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupFileAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupClassAction);
        this.updateGroupingActions();
    }

    public void setGrouping(int groupOrder) {
        this._currentGrouping = groupOrder;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(groupOrder);
        this.updateGroupingActions();
        this.getSettings().put(KEY_GROUPING, this._currentGrouping);
    }

    private void updateGroupingActions() {
        this._groupProjectAction.setChecked(this._currentGrouping == 4);
        this._groupFoldersAction.setChecked(this._currentGrouping == 3);
        this._groupFileAction.setChecked(this._currentGrouping == 2);
        this._groupClassAction.setChecked(this._currentGrouping == 1);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private IFile getCanonicalFile(IFile originalFile) {
        if (originalFile == null) {
            return null;
        }
        File tempFile = originalFile.getRawLocation().toFile();
        String canonicalPath = null;
        try {
            canonicalPath = tempFile.getCanonicalPath();
        }
        catch (IOException iOException) {}
        if (canonicalPath != null && !originalFile.isLinked()) {
            Path path = new Path(canonicalPath);
            originalFile = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        }
        return originalFile;
    }
}

